/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class K8sJSONSchemasGenerator
implements Runnable {
    private final Logger log = Logger.getLogger(K8sJSONSchemasGenerator.class.getName());
    private final Path sourceBase;
    private final String tagsUrl;
    private final String urlTemplate;
    private final boolean force;

    public K8sJSONSchemasGenerator(Path sourceBase, Map<String, String> configuration) {
        this.sourceBase = sourceBase;
        this.tagsUrl = Objects.requireNonNull(configuration.get("tagsUrl"), () -> "No tagsUrl in " + configuration);
        this.urlTemplate = Objects.requireNonNull(configuration.get("specUrlTemplate"), () -> "No specUrlTemplate in " + configuration);
        this.force = Boolean.parseBoolean(configuration.get("force"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpClient httpClient = HttpClient.newHttpClient();
        JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(Map.of());
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Map.of("javax.json.stream.JsonGenerator.prettyPrinting", true));
        ExecutorService tasks = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors()), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, this.getClass().getName() + "-" + this.counter.incrementAndGet());
            }
        });
        try {
            Path root = Files.createDirectories(this.sourceBase.resolve("assets/generated/kubernetes/jsonschema"), new FileAttribute[0]);
            for (String version : this.fetchTags(httpClient, this.tagsUrl, jsonReaderFactory)) {
                String url = this.urlTemplate.replace("{{version}}", version);
                tasks.submit(() -> {
                    try {
                        this.generate(Files.createDirectories(root.resolve(version), new FileAttribute[0]), url, httpClient, jsonBuilderFactory, jsonReaderFactory, jsonWriterFactory);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException(ioe);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            tasks.shutdownNow();
            try {
                if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    this.log.warning(() -> "Wrong interruption of generation task");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Iterable<String> fetchTags(final HttpClient httpClient, final String uri, final JsonReaderFactory jsonReaderFactory) throws IOException, InterruptedException {
        return () -> new Iterator<String>(){
            private URI next;
            private Iterator delegate;
            {
                this.next = URI.create(uri);
            }

            @Override
            public boolean hasNext() {
                if (this.delegate != null && this.delegate.hasNext()) {
                    return true;
                }
                if (this.next == null) {
                    return false;
                }
                try {
                    JsonArray array;
                    K8sJSONSchemasGenerator.this.log.info(() -> "Fetching " + this.next);
                    HttpResponse<String> response = httpClient.send(HttpRequest.newBuilder().GET().uri(this.next).header("accept", "application/json").build(), HttpResponse.BodyHandlers.ofString());
                    switch (response.statusCode()) {
                        case 200: {
                            break;
                        }
                        case 403: {
                            K8sJSONSchemasGenerator.this.log.warning(() -> "Rate limit hit, skipping for this run: " + response);
                            return false;
                        }
                        default: {
                            throw new IllegalStateException("Invalid response: " + response);
                        }
                    }
                    try (JsonReader reader = jsonReaderFactory.createReader((Reader)new StringReader(response.body()));){
                        array = reader.readArray();
                    }
                    this.next = response.headers().allValues("link").stream().flatMap(it -> Stream.of(it.split(","))).map(String::strip).filter(it -> it.endsWith("rel=\"next\"")).findFirst().map(it -> URI.create(it.substring(it.indexOf("<") + 1, it.indexOf(">")))).orElse(null);
                    this.delegate = array.stream().map(JsonValue::asJsonObject).map(i -> i.getString("name")).filter(it -> !it.contains("-alpha.") && !it.contains("-beta.") && !it.contains("-rc.")).iterator();
                    if (!this.delegate.hasNext()) {
                        return this.hasNext();
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public String next() {
                return (String)this.delegate.next();
            }
        };
    }

    private void generate(Path root, String url, HttpClient httpClient, JsonBuilderFactory jsonBuilderFactory, JsonReaderFactory jsonReaderFactory, JsonWriterFactory jsonWriterFactory) throws IOException, InterruptedException {
        JsonObject spec;
        HttpResponse<String> response = httpClient.send(HttpRequest.newBuilder().GET().uri(URI.create(url)).build(), HttpResponse.BodyHandlers.ofString());
        switch (response.statusCode()) {
            case 200: {
                break;
            }
            case 404: {
                this.log.info(() -> "No spec for '" + url + "'");
                return;
            }
            default: {
                throw new IllegalStateException("Invalid response: " + response);
            }
        }
        try (JsonReader reader = jsonReaderFactory.createReader((Reader)new StringReader(response.body()));){
            spec = reader.readObject();
        }
        Map<String, JsonObject> definitions = spec.getJsonObject("definitions").entrySet().stream().filter(it -> ((JsonValue)it.getValue()).getValueType() == JsonValue.ValueType.OBJECT).collect(Collectors.toMap(Map.Entry::getKey, it -> ((JsonValue)it.getValue()).asJsonObject()));
        for (Map.Entry<String, JsonObject> definition : definitions.entrySet()) {
            JsonObject obj = definition.getValue().asJsonObject();
            JsonValue meta = (JsonValue)obj.get((Object)"x-kubernetes-group-version-kind");
            if (meta == null || meta.getValueType() != JsonValue.ValueType.ARRAY) continue;
            for (JsonValue entry : meta.asJsonArray()) {
                JsonObject currentMeta = entry.asJsonObject();
                if (!currentMeta.containsKey((Object)"kind") || !currentMeta.containsKey((Object)"version")) continue;
                String version = currentMeta.getString("version");
                String kind = currentMeta.getString("kind");
                String filename = kind + ".jsonschema.json";
                Path versionned = Files.createDirectories(root.resolve(version), new FileAttribute[0]).resolve(filename);
                Path versionless = root.resolve(filename);
                String jsonString = null;
                if (this.force || !Files.exists(versionned, new LinkOption[0])) {
                    jsonString = this.doResolve(jsonBuilderFactory, jsonWriterFactory, definitions, obj);
                    Files.writeString(versionned, (CharSequence)jsonString, new OpenOption[0]);
                    this.log.info(() -> "Wrote '" + versionned + "'");
                }
                if (!this.force && Files.exists(versionless, new LinkOption[0])) continue;
                if (jsonString == null) {
                    jsonString = this.doResolve(jsonBuilderFactory, jsonWriterFactory, definitions, obj);
                }
                Files.writeString(versionless, (CharSequence)jsonString, new OpenOption[0]);
                this.log.info(() -> "Wrote '" + versionless + "'");
            }
        }
    }

    private String doResolve(JsonBuilderFactory jsonBuilderFactory, JsonWriterFactory jsonWriterFactory, Map<String, JsonObject> definitions, JsonObject obj) {
        JsonObject resolved = this.resolveRefs(jsonBuilderFactory, definitions, obj).build();
        StringWriter out = new StringWriter();
        try (JsonWriter writer = jsonWriterFactory.createWriter((Writer)out);){
            writer.write((JsonStructure)resolved);
        }
        String jsonString = out.toString();
        if (jsonString.contains("$ref")) {
            throw new IllegalStateException("$ref should have been replaced: " + jsonString);
        }
        return jsonString;
    }

    private JsonObjectBuilder resolveRefs(JsonBuilderFactory jsonBuilderFactory, Map<String, JsonObject> definitions, JsonObject root) {
        JsonObjectBuilder current = jsonBuilderFactory.createObjectBuilder();
        block5: for (Map.Entry entry : root.entrySet()) {
            switch (((JsonValue)entry.getValue()).getValueType()) {
                case OBJECT: {
                    current.add((String)entry.getKey(), this.resolveRefs(jsonBuilderFactory, definitions, ((JsonValue)entry.getValue()).asJsonObject()));
                    continue block5;
                }
                case ARRAY: {
                    current.add((String)entry.getKey(), (JsonValue)jsonBuilderFactory.createArrayBuilder((Collection)((JsonValue)entry.getValue()).asJsonArray().stream().map(it -> it.getValueType() == JsonValue.ValueType.OBJECT ? this.resolveRefs(jsonBuilderFactory, definitions, it.asJsonObject()).build() : it).collect(Collectors.toList())).build());
                    continue block5;
                }
                case STRING: {
                    if ("$ref".equals(entry.getKey())) {
                        String ref = ((JsonString)JsonString.class.cast(entry.getValue())).getString();
                        JsonObjectBuilder schema = this.resolveRefs(jsonBuilderFactory, definitions, this.resolveRef(definitions, ref, jsonBuilderFactory));
                        current.addAll(schema);
                        continue block5;
                    }
                    if (((String)entry.getKey()).startsWith("x-")) continue block5;
                    current.add((String)entry.getKey(), (JsonValue)entry.getValue());
                    continue block5;
                }
            }
            current.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return current;
    }

    private JsonObject resolveRef(Map<String, JsonObject> definitions, String ref, JsonBuilderFactory jsonBuilderFactory) {
        if (!ref.startsWith("#/definitions/")) {
            throw new IllegalArgumentException("Wrong ref: '" + ref + "'");
        }
        String key = ref.substring("#/definitions/".length());
        if (key.substring(key.lastIndexOf(46) + 1).startsWith("JSON")) {
            return jsonBuilderFactory.createObjectBuilder().add("type", "object").build();
        }
        return Objects.requireNonNull(definitions.get(key), () -> "Didn't find ref '" + ref + "'");
    }
}

