/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.command.Executable;
import io.yupiik.bundlebee.documentation.DocEntryFormatter;
import io.yupiik.bundlebee.documentation.FinderFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CommandConfigurationGenerator
implements Runnable {
    private final Logger log = Logger.getLogger(CommandConfigurationGenerator.class.getName());
    protected final Path sourceBase;
    protected final Map<String, String> configuration;

    @Override
    public void run() {
        try {
            Path output = this.sourceBase.resolve("content/commands");
            Files.createDirectories(output, new FileAttribute[0]);
            List<Path> docs = this.generate(output, new FinderFactory(this.configuration).finder());
            Path commandsAdoc = output.getParent().resolve("commands.adoc");
            Files.writeString(commandsAdoc, (CharSequence)("= Available commands\n:minisite-index: 300\n:minisite-index-title: Commands\n:minisite-index-description: Available commands.\n:minisite-index-icon: terminal\n\n\n" + docs.stream().sorted(Path::compareTo).map(it -> {
                String filename = it.getFileName().toString();
                return "- xref:commands/" + filename + "[" + filename.substring(0, filename.length() - ".configuration.adoc".length()) + "]";
            }).collect(Collectors.joining("\n")) + "\n"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.log.info("Created " + commandsAdoc);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Path> generate(Path base, AnnotationFinder finder) {
        DocEntryFormatter formatter = new DocEntryFormatter();
        return finder.enableFindImplementations().findImplementations(Executable.class).stream().filter(it -> !Modifier.isAbstract(it.getModifiers()) && !it.isInterface()).map(command -> {
            try {
                Executable instance = command.asSubclass(Executable.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                String name = instance.name();
                Pattern prefix = Pattern.compile("^bundlebee\\." + name + "\\.");
                String config = new ClassFinder(new Class[]{command}).findAnnotatedFields(ConfigProperty.class).stream().map(it -> formatter.format((Field)it, k -> prefix.matcher((CharSequence)k).replaceAll(""))).sorted().collect(Collectors.joining("\n\n"));
                Path conf = base.resolve(name + ".configuration.adoc");
                Files.writeString(conf, (CharSequence)("= " + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "\n\n" + instance.description() + "\n\nName: `" + name + "`.\n\n== Configuration\n\n" + (config.isEmpty() ? "No configuration." : config) + "\n"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.log.info("Created " + conf);
                return conf;
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }

    public CommandConfigurationGenerator(Path sourceBase, Map<String, String> configuration) {
        this.sourceBase = sourceBase;
        this.configuration = configuration;
    }
}

