/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.probes;

import io.yupiik.batch.ui.backend.probes.Probes;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Set;
import javax.sql.DataSource;

@Dependent
public class ProbesRegistration
implements ServletContainerInitializer {
    @Inject
    private DataSource dataSource;

    public void onStartup(Set<Class<?>> set, ServletContext servletContext) {
        this.add(servletContext, new Probes(this.dataSource, true), "/api/health/live");
        this.add(servletContext, new Probes(this.dataSource, false), "/api/health/ready");
    }

    private void add(ServletContext servletContext, Probes probes, String mapping) {
        ServletRegistration.Dynamic servlet = servletContext.addServlet(mapping.substring(1).replace('/', '-'), (Servlet)probes);
        servlet.setLoadOnStartup(1);
        servlet.setAsyncSupported(true);
        servlet.addMapping(new String[]{mapping});
    }
}

