/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.configuration;

import io.yupiik.batch.ui.backend.configuration.Configuration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

@ApplicationScoped
public class DataSourceProducer {
    @Produces
    public DataSource dataSource(Configuration configuration) {
        PoolProperties properties = new PoolProperties();
        properties.setDriverClassName(configuration.getDriver());
        properties.setUrl(configuration.getUrl());
        properties.setUsername(configuration.getUsername());
        properties.setPassword(configuration.getPassword());
        properties.setTestOnBorrow(configuration.isTestOnBorrow());
        properties.setTestOnReturn(configuration.isTestOnReturn());
        properties.setTestWhileIdle(configuration.isTestWhileIdle());
        properties.setMinEvictableIdleTimeMillis(configuration.getMinEvictableIdleTime());
        properties.setTimeBetweenEvictionRunsMillis(configuration.getTimeBetweenEvictionRuns());
        properties.setValidationQuery(configuration.getValidationQuery());
        properties.setValidationQueryTimeout(configuration.getValidationQueryTimeout());
        properties.setDefaultAutoCommit(Boolean.valueOf(false));
        properties.setMinIdle(configuration.getMinIdle());
        properties.setMaxActive(configuration.getMaxActive());
        properties.setMaxIdle(configuration.getMaxActive());
        return new DataSource((PoolConfiguration)properties);
    }

    public void release(@Disposes DataSource dataSource) {
        dataSource.close();
    }
}

