/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.configuration;

import io.yupiik.batch.runtime.batch.Binder;
import io.yupiik.batch.runtime.batch.Param;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ApplicationScoped
public class Configuration {
    @Param(name="yupiik.batch.frontend.extensionsJs", description="Javascript path to a Yupiik Batch frontend extension. Script is injected just before yupiik-batch main one, i.e. after libraries ones but note they are minified wih webpack.")
    private String frontendExtensionsJs;
    @Param(name="yupiik.batch.backend.tomcat.port", description="Tomcat port.")
    private int port = 8080;
    @Param(name="yupiik.batch.backend.tomcat.accessLogPattern", description="Tomcat access log pattern.")
    private String accessLogPattern = "common";
    @Param(name="yupiik.batch.backend.tomcat.webUsers", description="List of allowed users - by default all are. It uses a properties syntax: `user=password`. Security uses a web BASIC mecanism.")
    private String webUsers;
    @Param(name="yupiik.batch.backend.datasource.driver", required=true, description="Datasource driver.")
    private String driver;
    @Param(name="yupiik.batch.backend.datasource.url", required=true, description="Datasource URL.")
    private String url;
    @Param(name="yupiik.batch.backend.datasource.username", description="Datasource username.")
    private String username;
    @Param(name="yupiik.batch.backend.datasource.password", description="Datasource password.")
    private String password;
    @Param(name="yupiik.batch.backend.datasource.testOnBorrow", description="Should connections be tested on borrow time.")
    private boolean testOnBorrow;
    @Param(name="yupiik.batch.backend.datasource.testOnReturn", description="Should connections be tested on return to the pool time.")
    private boolean testOnReturn;
    @Param(name="yupiik.batch.backend.datasource.testWhileIdle", description="Should connections be tested in background.")
    private boolean testWhileIdle;
    @Param(name="yupiik.batch.backend.datasource.timeBetweenEvictionRuns", description="Time between background evictions in ms.")
    private int timeBetweenEvictionRuns;
    @Param(name="yupiik.batch.backend.datasource.minEvictableIdleTime", description="How long to await before a connection is considered idled and evictable.")
    private int minEvictableIdleTime;
    @Param(name="yupiik.batch.backend.datasource.validationQuery", description="Validation query to validate the connection when enabled.")
    private String validationQuery;
    @Param(name="yupiik.batch.backend.datasource.validationQueryTimeout", description="How long to await for the validation query.")
    private int validationQueryTimeout;
    @Param(name="yupiik.batch.backend.datasource.minIdle", description="Min connections in the pool.")
    private int minIdle = 2;
    @Param(name="yupiik.batch.backend.datasource.maxConnections", description="Max connections in the pool.")
    private int maxActive = 16;
    @Param(name="yupiik.batch.backend.database.jobTable", description="Job table to query.")
    private String jobTable = "BATCH_JOB_EXECUTION_TRACE";
    @Param(name="yupiik.batch.backend.database.stepTable", description="Step table to query.")
    private String stepTable = "BATCH_STEP_EXECUTION_TRACE";
    @Param(name="yupiik.batch.backend.queries.findAllJobs", description="Find all jobs with pagination SQL query (for portability), `${table}` is replaced by the table name. Parameters can be `${pageSize}`, `${firstIndex}` - inclusive, `${lastIndex}` - exclusive.")
    private String findAllJobs = "SELECT id, name, status, comment, started, finished FROM ${table} ORDER BY finished DESC LIMIT ${pageSize} OFFSET ${firstIndex}";
    @Param(name="yupiik.batch.backend.queries.countAllJobs", description="Count all jobs SQL query (for portability), `${table}` is replaced by the table name.")
    private String countAllJobs = "SELECT count(*) FROM ${table}";
    @Param(name="yupiik.batch.backend.queries.findLastExecutions", description="SQL query (for portability) to find last execution of each batch, `${table}` is replaced by the table name.")
    private String findLastExecutions = "SELECT t.id, t.name, t.status, t.comment, t.started, t.finished FROM ${table} t INNER JOIN(SELECT name, max(finished) as finished FROM ${table} GROUP BY name) as v on t.name = v.name and t.finished = v.finished ORDER BY name DESC";
    @Param(name="yupiik.batch.backend.queries.findJobById", description="Find a job by id SQL query (for portability), `${table}` is replaced by the table name.")
    private String findJobById = "SELECT id, name, status, comment, started, finished FROM ${table} WHERE id = ?";
    @Param(name="yupiik.batch.backend.queries.findStepsByJobId", description="Find aall steps related to a job id SQL query (for portability), `${table}` is replaced by the step table name.")
    private String findStepsByJobId = "SELECT id, name, status, comment, started, finished, previous_id FROM ${table} WHERE job_id = ?";

    @PostConstruct
    private void init() {
        List params = System.getProperties().stringPropertyNames().stream().filter(it -> it.startsWith("yupiik.")).flatMap(it -> Stream.of("--" + it, System.getProperty(it))).collect(Collectors.toList());
        new Binder(null, params).bind((Object)this);
    }

    public String getFindLastExecutions() {
        return this.findLastExecutions;
    }

    public String getFrontendExtensionsJs() {
        return this.frontendExtensionsJs;
    }

    public String getWebUsers() {
        return this.webUsers;
    }

    public int getPort() {
        return this.port;
    }

    public String getAccessLogPattern() {
        return this.accessLogPattern;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getFindJobById() {
        return this.findJobById;
    }

    public String getFindStepsByJobId() {
        return this.findStepsByJobId;
    }

    public String getFindAllJobs() {
        return this.findAllJobs;
    }

    public String getCountAllJobs() {
        return this.countAllJobs;
    }

    public String getJobTable() {
        return this.jobTable;
    }

    public String getStepTable() {
        return this.stepTable;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public int getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public int getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }
}

