/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.frontend;

import io.yupiik.batch.ui.backend.configuration.Configuration;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Dependent
public class FrontendRouter
extends HttpServlet {
    @Inject
    private Configuration configuration;
    private byte[] indexHtmlBytes;

    public void init(ServletConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = config.getServletContext().getClassLoader().getResourceAsStream("META-INF/resources/index.html");){
            Objects.requireNonNull(in, "didn't find index.html").transferTo(out);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.indexHtmlBytes = this.rewrite(out.toString(StandardCharsets.UTF_8));
    }

    public void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setBufferSize(this.indexHtmlBytes.length);
        servletResponse.setContentType("text/html");
        try (ServletOutputStream out = servletResponse.getOutputStream();){
            out.write(this.indexHtmlBytes);
        }
    }

    private byte[] rewrite(String indexHtml) {
        String js = this.configuration.getFrontendExtensionsJs();
        if (js != null && !js.isBlank()) {
            int start = indexHtml.indexOf("<script src=\"/static/js/main.");
            if (start < 0) {
                throw new IllegalArgumentException("Unexpected html");
            }
            return (indexHtml.substring(0, start) + "<script src=\"" + js + "\"></script>" + indexHtml.substring(start)).getBytes(StandardCharsets.UTF_8);
        }
        return indexHtml.getBytes(StandardCharsets.UTF_8);
    }
}

