/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.probes;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Probes
extends HttpServlet {
    private final DataSource dataSource;
    private final boolean live;

    public Probes(DataSource dataSource, boolean live) {
        this.dataSource = dataSource;
        this.live = live;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        if (!this.live) {
            this.doReady(resp);
        } else {
            this.doLive(resp);
        }
    }

    private void doReady(HttpServletResponse resp) {
        this.doLive(resp);
    }

    private void doLive(HttpServletResponse resp) {
        try (Connection c = this.dataSource.getConnection();){
            if (c.isValid(30000)) {
                resp.setStatus(200);
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resp.setContentType("text/plain");
        resp.setStatus(503);
    }
}

