/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.sql;

import io.yupiik.batch.runtime.sql.SQLFunction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IteratingResultset<A>
implements Iterator<A> {
    private final SQLFunction<ResultSet, A> mapper;
    private final ResultSet resultSet;

    public IteratingResultset(SQLFunction<ResultSet, A> mapper, ResultSet resultSet) {
        this.mapper = mapper;
        this.resultSet = resultSet;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException throwables) {
            throw new IllegalStateException(throwables);
        }
    }

    @Override
    public A next() {
        try {
            return (A)this.mapper.apply((Object)this.resultSet);
        }
        catch (SQLException throwables) {
            throw new IllegalStateException(throwables);
        }
    }

    public static <A> List<A> toList(ResultSet resultSet, SQLFunction<ResultSet, A> mapper) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new IteratingResultset<A>(mapper, resultSet), 1024), false).collect(Collectors.toList());
    }
}

