/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.batch.ui.backend.configuration;

import io.yupiik.batch.ui.backend.configuration.Configuration;
import io.yupiik.uship.webserver.tomcat.TomcatWebServerConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;

@Dependent
public class TomcatConfigurationProducer {
    @Produces
    @ApplicationScoped
    public TomcatWebServerConfiguration configuration(Configuration configuration) {
        TomcatWebServerConfiguration tomcat = new TomcatWebServerConfiguration();
        tomcat.setPort(configuration.getPort());
        tomcat.setAccessLogPattern(configuration.getAccessLogPattern());
        if (configuration.getWebUsers() != null && !configuration.getWebUsers().isBlank()) {
            Properties users = this.readUsers(configuration);
            tomcat.setTomcatCustomizers(List.of(t -> users.stringPropertyNames().forEach(user -> t.addUser(user, users.getProperty((String)user)))));
            tomcat.setContextCustomizers(List.of(this::enforceAuthentication));
        }
        return tomcat;
    }

    private void enforceAuthentication(Context c) {
        c.getPipeline().addValve((Valve)new BasicAuthenticator());
        LoginConfig loginConfig = new LoginConfig();
        loginConfig.setAuthMethod("BASIC");
        loginConfig.setRealmName("Yupiik Batch UI");
        loginConfig.setCharset(StandardCharsets.UTF_8);
        c.setLoginConfig(loginConfig);
        SecurityCollection securityCollection = new SecurityCollection();
        securityCollection.addPattern("/*");
        securityCollection.setName("Yupiik Batch UI Security");
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setCharset(StandardCharsets.UTF_8);
        constraint.setAuthConstraint(true);
        constraint.addCollection(securityCollection);
        constraint.addAuthRole("**");
        c.addConstraint(constraint);
    }

    private Properties readUsers(Configuration configuration) {
        Properties users = new Properties();
        try (StringReader reader = new StringReader(configuration.getWebUsers());){
            users.load(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return users;
    }
}

