package io.ygdrasil.webgpu.examples.scenes.shader.vertex

// language=wgsl
val instancedShader = """
	struct Uniforms {
	  modelViewProjectionMatrix : array<mat4x4f, 16>,
	}

	@binding(0) @group(0) var<uniform> uniforms : Uniforms;

	struct VertexOutput {
	  @builtin(position) Position : vec4f,
	  @location(0) fragUV : vec2f,
	  @location(1) fragPosition: vec4f,
	}

	@vertex
	fn main(
	  @builtin(instance_index) instanceIdx : u32,
	  @location(0) position : vec4f,
	  @location(1) uv : vec2f
	) -> VertexOutput {
	  var output : VertexOutput;
	  output.Position = uniforms.modelViewProjectionMatrix[instanceIdx] * position;
	  output.fragUV = uv;
	  output.fragPosition = 0.5 * (position + vec4(1.0));
	  return output;
	}
""".trimIndent()