/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.LogProvider;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.xml.sax.Attributes;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;

public class XSpecCounterContentHandler
extends DefaultHandler2 {
    public static final String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    private final Counters globalCounters;
    private Counters currentCounters;
    private boolean pendingScenario = true;
    private final LogProvider logProvider;
    private final String systemId;
    private final URIResolver uriResolver;
    private final Map<String, Counters> sharedScenarios;
    private final boolean activateLogs;
    private final String LOG_PREFIX;
    private XSpecCounterContentHandler importedTestFilter;

    public XSpecCounterContentHandler(String systemId, URIResolver uriResolver, LogProvider logProvider, boolean activateLogs, String ... prefix) {
        this.systemId = systemId;
        this.uriResolver = uriResolver;
        this.logProvider = logProvider;
        this.activateLogs = activateLogs;
        this.LOG_PREFIX = prefix.length > 0 ? prefix[0] : "";
        this.currentCounters = this.globalCounters = new Counters();
        this.sharedScenarios = new HashMap<String, Counters>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.activateLogs) {
            this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "startElement(" + uri + "," + localName + "," + qName + ",...)"));
        }
        if (XSPEC_NS.equals(uri) && ("pendingTests".equals(localName) || "pending".equals(localName))) {
            this.currentCounters.pendingWrapper++;
        } else if (XSPEC_NS.equals(uri) && "scenario".equals(localName)) {
            if (this.isTrue(atts.getValue("shared"))) {
                String scenarioName = atts.getValue("label");
                Counters scenarioCounters = new Counters();
                this.sharedScenarios.put(scenarioName, scenarioCounters);
                this.currentCounters = scenarioCounters;
            }
            if (atts.getValue("pendingTests") != null || atts.getValue("pending") != null) {
                this.currentCounters.pendingWrapper++;
                this.pendingScenario = true;
                if (this.activateLogs) {
                    this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "entering pending scenario"));
                }
            }
        } else if (XSPEC_NS.equals(uri) && "expect".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "entering expect"));
            }
            if (this.currentCounters.pendingWrapper > 0) {
                this.currentCounters.pendingTests++;
            }
            this.currentCounters.tests++;
        } else if (XSPEC_NS.equals(uri) && "like".equals(localName)) {
            String scenarioName = atts.getValue("label");
            Counters scenarioCounters = this.sharedScenarios.get(scenarioName);
            this.currentCounters.pendingTests += scenarioCounters.pendingTests;
            this.currentCounters.tests += scenarioCounters.tests;
            this.currentCounters.pendingWrapper += scenarioCounters.pendingWrapper;
        } else if (XSPEC_NS.equals(uri) && "import".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "[in " + this.systemId + "] seeing imported XSpec " + atts.getValue("href")));
            }
            String importedSystemId = null;
            try {
                Source source = this.uriResolver.resolve(atts.getValue("href"), this.systemId);
                importedSystemId = source.getSystemId();
            }
            catch (TransformerException ex) {
                this.logProvider.getLog().error((CharSequence)("while resolving " + atts.getValue("href") + " to " + this.systemId), (Throwable)ex);
            }
            if (importedSystemId != null) {
                try {
                    if (this.activateLogs) {
                        this.logProvider.getLog().warn((CharSequence)(this.LOG_PREFIX + "[in " + this.systemId + "] parsing imported XSpec " + importedSystemId));
                    }
                    Parser parser = XmlStuff.PARSER_FACTORY.newSAXParser().getParser();
                    ParserAdapter reader = new ParserAdapter(parser);
                    this.importedTestFilter = new XSpecCounterContentHandler(importedSystemId, this.uriResolver, this.logProvider, this.activateLogs, XSPEC_NS + importedSystemId + ": ");
                    XMLFilterImpl filter = new XMLFilterImpl(reader){

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                            super.startElement(uri, localName, qName, atts);
                            XSpecCounterContentHandler.this.importedTestFilter.startElement(uri, localName, qName, atts);
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            super.endElement(uri, localName, qName);
                            XSpecCounterContentHandler.this.importedTestFilter.endElement(uri, localName, qName);
                        }
                    };
                    filter.parse(importedSystemId);
                }
                catch (IOException | ParserConfigurationException | SAXException ex) {
                    this.logProvider.getLog().error((CharSequence)("[" + this.systemId + "] while counting into imported " + importedSystemId), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (XSPEC_NS.equals(uri) && ("pendingTests".equals(localName) || "pending".equals(localName))) {
            this.currentCounters.pendingWrapper--;
        } else if (XSPEC_NS.equals(uri) && "scenario".equals(localName)) {
            if (this.pendingScenario) {
                this.currentCounters.pendingWrapper--;
                this.pendingScenario = false;
                if (this.activateLogs) {
                    this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "exiting pending scenario"));
                }
            }
            this.currentCounters = this.globalCounters;
        } else if (XSPEC_NS.equals(uri) && "import".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "Adding " + this.importedTestFilter.getTests() + " tests"));
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "Adding " + this.importedTestFilter.getPendingTests() + " pending tests"));
            }
            this.currentCounters.tests = this.currentCounters.tests + this.importedTestFilter.getTests();
            this.currentCounters.pendingTests = this.currentCounters.pendingTests + this.importedTestFilter.getPendingTests();
            this.importedTestFilter = null;
        }
    }

    private boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("yes".equals(value)) {
            return true;
        }
        return "1".equals(value);
    }

    public int getTests() {
        return this.globalCounters.tests;
    }

    public int getPendingTests() {
        return this.globalCounters.pendingTests;
    }

    public static class Counters {
        private int tests = 0;
        private int pendingTests = 0;
        private int pendingWrapper = 0;
    }
}

