/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.CompiledXSpec;
import io.xspec.maven.xspecMavenPlugin.utils.LogProvider;
import io.xspec.maven.xspecMavenPlugin.utils.RunnerOptions;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecTestFilter;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSpecCompiler
implements LogProvider {
    private final XmlStuff xmlStuff;
    private final Log log;
    private final RunnerOptions options;
    private final HashMap<File, File> executionReportDirs;
    private final List<File> filesToDelete;
    public static final QName QN_STYLESHEET = new QName("stylesheet-uri");
    public static final QName QN_URI = new QName("uri");

    public XSpecCompiler(XmlStuff xmlStuff, RunnerOptions options, Log log) {
        this.xmlStuff = xmlStuff;
        this.log = log;
        this.options = options;
        this.executionReportDirs = new HashMap();
        this.filesToDelete = new ArrayList<File>();
    }

    public final CompiledXSpec compileXSpecForXQuery(File sourceFile) {
        return this.compileXSpec(sourceFile, this.xmlStuff.getXspec4xqueryCompiler());
    }

    public final CompiledXSpec compileXSpecForXslt(File sourceFile) {
        return this.compileXSpec(sourceFile, this.xmlStuff.getXspec4xsltCompiler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompiledXSpec compileXSpec(File sourceFile, XsltExecutable compilerExec) {
        XsltTransformer compiler = compilerExec.load();
        InputStream isXSpec = null;
        try {
            File compiledXSpec = this.getCompiledXSpecPath(this.options.reportDir, sourceFile);
            this.log.info((CharSequence)("Compiling XSpec to XSLT: " + compiledXSpec));
            isXSpec = new FileInputStream(sourceFile);
            SAXParser parser = XmlStuff.PARSER_FACTORY.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XSpecTestFilter xspecTestFilter = new XSpecTestFilter(reader, sourceFile.toURI().toString(), this.xmlStuff.getUriResolver(), this, false, new String[0]);
            InputSource inXSpec = new InputSource(isXSpec);
            inXSpec.setSystemId(sourceFile.toURI().toString());
            compiler.setSource((Source)new SAXSource(xspecTestFilter, inXSpec));
            Serializer serializer = this.xmlStuff.getProcessor().newSerializer();
            serializer.setOutputFile(compiledXSpec);
            compiler.setDestination((Destination)serializer);
            compiler.transform();
            CompiledXSpec compiledXSpec2 = new CompiledXSpec(xspecTestFilter.getTests(), xspecTestFilter.getPendingTests(), compiledXSpec);
            return compiledXSpec2;
        }
        catch (SaxonApiException sae) {
            this.getLog().error((CharSequence)sae.getMessage());
            this.getLog().debug((Throwable)sae);
        }
        catch (FileNotFoundException | ParserConfigurationException pce) {
            this.getLog().error((Throwable)pce);
        }
        catch (SAXException saxe) {
            this.getLog().error((CharSequence)saxe.getMessage());
            this.getLog().debug((Throwable)saxe);
        }
        finally {
            if (isXSpec != null) {
                try {
                    isXSpec.close();
                }
                catch (IOException ioe) {
                    this.getLog().warn((Throwable)ioe);
                }
            }
        }
        return null;
    }

    public XdmNode prepareSchematronDocument(XdmNode xspecDocument) throws SaxonApiException, TransformerException, IOException {
        XsltTransformer step1 = this.xmlStuff.getSchematronDsdl().load();
        XsltTransformer step2 = this.xmlStuff.getSchematronExpand().load();
        XsltTransformer step3 = this.xmlStuff.getSchematronSvrl().load();
        XPathSelector xp = this.xmlStuff.getXPathCompiler().compile("/x:description/x:param[@name='phase'][1]/text()").load();
        xp.setContextItem((XdmItem)xspecDocument);
        XdmItem phaseItem = xp.evaluateSingle();
        if (phaseItem != null) {
            String phase = phaseItem.getStringValue();
            this.getLog().debug((CharSequence)("Evaluating phase: " + phase));
            if (phase != null && !phase.isEmpty()) {
                step3.setParameter(new QName("phase"), (XdmValue)new XdmAtomicValue(phase));
            }
        }
        step3.setParameter(new QName("allow-foreign"), (XdmValue)new XdmAtomicValue("true"));
        File sourceFile = new File(xspecDocument.getBaseURI());
        step1.setDestination((Destination)step2);
        step2.setDestination((Destination)step3);
        File compiledSchematronDest = this.getCompiledSchematronPath(this.options.reportDir, sourceFile);
        Serializer serializer = this.xmlStuff.newSerializer(new FileOutputStream(compiledSchematronDest));
        step3.setDestination((Destination)serializer);
        XPathSelector xpSchemaPath = this.xmlStuff.getXPathCompiler().compile("/*/@schematron").load();
        xpSchemaPath.setContextItem((XdmItem)xspecDocument);
        String schematronPath = xpSchemaPath.evaluateSingle().getStringValue();
        Source source = this.xmlStuff.getUriResolver().resolve(schematronPath, xspecDocument.getBaseURI().toString());
        step1.setInitialContextNode(this.xmlStuff.getDocumentBuilder().build(source));
        step1.transform();
        this.getLog().debug((CharSequence)("Schematron compiled ! " + compiledSchematronDest.getAbsolutePath()));
        XsltTransformer schut = this.xmlStuff.getSchematronSchut().load();
        schut.setParameter(QN_STYLESHEET, (XdmValue)new XdmAtomicValue(compiledSchematronDest.toURI().toString()));
        schut.setInitialContextNode(xspecDocument);
        File resultFile = this.getCompiledXspecSchematronPath(this.options.reportDir, sourceFile);
        Serializer schutSerializer = this.xmlStuff.newSerializer(new FileOutputStream(resultFile));
        schut.setDestination((Destination)schutSerializer);
        schut.setBaseOutputURI(resultFile.toURI().toString());
        schut.transform();
        this.getLog().debug((CharSequence)("XSpec for schematron compiled: " + resultFile.getAbsolutePath()));
        XdmNode result = this.xmlStuff.getDocumentBuilder().build(resultFile);
        if (!resultFile.exists()) {
            this.getLog().error((CharSequence)(resultFile.getAbsolutePath() + " has not be written"));
        }
        this.getLog().info((CharSequence)"Copying resource files referenced from XSpec for Schematron");
        XsltTransformer xslDependencyScanner = this.xmlStuff.getXmlDependencyScanner().load();
        xslDependencyScanner.setURIResolver(this.xmlStuff.getXsltCompiler().getURIResolver());
        XdmDestination xdmDest = new XdmDestination();
        xslDependencyScanner.setDestination((Destination)xdmDest);
        xslDependencyScanner.setInitialContextNode(xspecDocument);
        xslDependencyScanner.transform();
        XPathSelector xpFile = this.xmlStuff.getXpFileSearcher().load();
        xpFile.setContextItem((XdmItem)xdmDest.getXdmNode());
        XdmValue ret = xpFile.evaluate();
        for (int i = 0; i < ret.size(); ++i) {
            XdmNode node = (XdmNode)ret.itemAt(i);
            this.getLog().debug((CharSequence)("inspecting " + node.toString()));
            String uri = node.getAttributeValue(QN_URI);
            try {
                this.copyFile(xspecDocument.getUnderlyingNode().getSystemId(), uri, resultFile);
                continue;
            }
            catch (URISyntaxException ex) {
                throw new SaxonApiException("Saxon has generated an invalid URI : ", (Throwable)ex);
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"while copying Schematron resources...", (Throwable)ex);
            }
        }
        return result;
    }

    public final File getXSpecXmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "xml");
    }

    public final File getXSpecHtmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "html");
    }

    final File getCompiledXSpecPath(File xspecReportDir, File xspec) {
        return this.getCompiledPath(xspecReportDir, xspec, "xslt", ".xslt");
    }

    protected void copyFile(String baseUri, String referencedFile, File resultBase) throws IOException, URISyntaxException {
        this.getLog().debug((CharSequence)("copyFile(" + baseUri + ", " + referencedFile + ", " + resultBase.getAbsolutePath() + ")"));
        try {
            URI destUri = new URI(referencedFile);
            if (destUri.isAbsolute()) {
                this.getLog().debug((CharSequence)(referencedFile + " is absolute, do not replace it, do not copy file"));
                return;
            }
        }
        catch (Exception ex) {
            this.getLog().debug((CharSequence)(referencedFile + " is not a URI, try to resolve it as a relative path"), (Throwable)ex);
        }
        Path basePath = new File(new URI(baseUri)).getParentFile().toPath();
        File source = basePath.resolve(referencedFile).toFile();
        File dest = resultBase.getParentFile().toPath().resolve(referencedFile).normalize().toFile();
        if (!dest.exists()) {
            dest.mkdirs();
        }
        this.getLog().debug((CharSequence)("Copying " + source.getAbsolutePath() + " to " + dest.getAbsolutePath()));
        Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private File getCompiledPath(File xspecReportDir, File xspec, String name, String extension) {
        this.checkDirExists(xspecReportDir);
        Path relativeSource = this.options.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.getExecutionReportDir(xspecReportDir);
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        File fCompiledDir = new File(outputDir, name);
        if (!fCompiledDir.exists()) {
            fCompiledDir.mkdirs();
        }
        return new File(fCompiledDir, xspec.getName() + extension);
    }

    final File getCompiledSchematronPath(File xspecReportDir, File schematron) {
        File ret = this.getCompiledPath(xspecReportDir, schematron, "schematron", ".xslt");
        return ret;
    }

    final File getCompiledXspecSchematronPath(File xspecReportDir, File xspec) {
        File ret = this.getCompiledPath(xspecReportDir, xspec, FilenameUtils.getBaseName((String)xspec.getName()), "-compiled.xspec");
        this.filesToDelete.add(ret);
        return ret;
    }

    public final File getXSpecResultPath(File xspecReportDir, File xspec, String extension) {
        this.checkDirExists(xspecReportDir);
        Path relativeSource = this.options.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.getExecutionReportDir(xspecReportDir);
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        return new File(outputDir, xspec.getName().replace(".xspec", "") + "." + extension);
    }

    public final File getCoverageTempPath(File xspecReportDir, File xspec) {
        this.checkDirExists(xspecReportDir);
        Path relativeSource = this.options.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.options.executionId != null && !"default".equals(this.options.executionId) ? new File(xspecReportDir, this.options.executionId) : xspecReportDir;
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        return new File(outputDir, "coverage-" + xspec.getName().replace(".xspec", "") + ".xml");
    }

    public final File getCoverageFinalPath(File xspecReportDir, File xspec) {
        this.checkDirExists(xspecReportDir);
        Path relativeSource = this.options.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.options.executionId != null && !"default".equals(this.options.executionId) ? new File(xspecReportDir, this.options.executionId) : xspecReportDir;
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        return new File(outputDir, xspec.getName().replace(".xspec", "-coverage") + ".html");
    }

    private File getExecutionReportDir(File xspecReportDir) {
        File executionReportDir = this.executionReportDirs.get(xspecReportDir);
        if (executionReportDir == null) {
            executionReportDir = this.options.executionId != null && !"default".equals(this.options.executionId) ? new File(xspecReportDir, this.options.executionId) : xspecReportDir;
            executionReportDir.mkdirs();
            this.getLog().debug((CharSequence)("executionReportDir(" + xspecReportDir.getAbsolutePath() + ")=" + executionReportDir.getAbsolutePath()));
            this.executionReportDirs.put(xspecReportDir, executionReportDir);
        }
        return executionReportDir;
    }

    private void checkDirExists(File xspecReportDir) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    public List<File> getFilesToDelete() {
        return this.filesToDelete;
    }
}

