/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.resolver;

import io.xspec.maven.xspecMavenPlugin.utils.QuietLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlresolver.Catalog;
import org.xmlresolver.CatalogSource;

public class Resolver
implements URIResolver,
EntityResolver {
    private final URIResolver saxonResolver;
    private final Log log;
    org.xmlresolver.Resolver cr;
    private static final boolean LOG_ENABLE = false;
    private final Pattern protocolPattern;

    public Resolver(URIResolver saxonResolver, File catalog, Log log) {
        this.saxonResolver = saxonResolver;
        this.log = log;
        this.protocolPattern = Pattern.compile("^[\\w\\d]+:/.*");
        this.cr = new org.xmlresolver.Resolver(new Catalog());
        this.cr.getCatalog().addSource((CatalogSource)new CatalogSource.UriCatalogSource(catalog.toURI().toString()));
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.getLog().debug((CharSequence)String.format("resolve(%s,%s)", href, base));
        if (this.isCpProtocol(href, base)) {
            return this.resolveToClasspath(href, base);
        }
        this.getLog().debug((CharSequence)("catalogList=" + this.cr.getCatalog().catalogList()));
        this.getLog().debug((CharSequence)"Trying catalog");
        try {
            Source source = this.cr.resolve(href, base);
            this.getLog().debug((CharSequence)("source is " + (source == null ? "" : "not ") + "null"));
            if (source != null && source.getSystemId() != null) {
                this.getLog().debug((CharSequence)String.format("resolved from catalog to %s", source.getSystemId()));
                source.setSystemId(this.normalizeUrl(source.getSystemId()));
                return source;
            }
            this.getLog().debug((CharSequence)"Trying saxon");
            source = this.saxonResolver.resolve(href, base);
            if (source != null && source.getSystemId() != null) {
                this.getLog().debug((CharSequence)String.format("resolved from saxon to %s", source.getSystemId()));
                source.setSystemId(this.normalizeUrl(source.getSystemId()));
                return source;
            }
            this.getLog().error((CharSequence)String.format("fail to resolve (%s, %s)", href, base));
            return null;
        }
        catch (TransformerException ex) {
            this.getLog().error((CharSequence)("Resolver.resolve(" + href + "," + base + ")"), (Throwable)ex);
            throw ex;
        }
    }

    private String normalizeUrl(String systemId) {
        try {
            URL url = new URL(systemId);
            String protocol = url.getProtocol();
            String path = url.getPath();
            String host = url.getHost();
            return new URL(protocol, host, path.replaceAll("\\/\\/", "/")).toExternalForm();
        }
        catch (MalformedURLException ex) {
            return systemId;
        }
    }

    private boolean isCpProtocol(String href, String base) {
        return href != null && href.startsWith("cp:/") || base != null && base.startsWith("cp:/");
    }

    private Source resolveToClasspath(String href, String base) {
        String fullUrl = this.isAbsolute(href) ? href : base + href;
        String path = this.removeCpPrefix(fullUrl);
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        StreamSource ret = new StreamSource(is);
        String systemId = this.getClass().getResource(path).toExternalForm();
        this.log.warn((CharSequence)systemId);
        ret.setSystemId(this.normalizeUrl(systemId));
        return ret;
    }

    private boolean isAbsolute(String href) {
        return this.protocolPattern.matcher(href).matches();
    }

    private String removeCpPrefix(String fullUrl) {
        return fullUrl.substring(3);
    }

    private Log getLog() {
        return QuietLogger.getLogger();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.cr.resolveEntity(publicId, systemId);
    }
}

