/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import io.xspec.maven.xspecMavenPlugin.XSpecRunner;
import io.xspec.maven.xspecMavenPlugin.resources.SchematronImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecPluginResources;
import io.xspec.maven.xspecMavenPlugin.resources.impl.DefaultSchematronImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.impl.DefaultXSpecImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.impl.DefaultXSpecPluginResources;
import io.xspec.maven.xspecMavenPlugin.utils.LogProvider;
import io.xspec.maven.xspecMavenPlugin.utils.RunnerOptions;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecFailureException;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.s9api.QName;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import top.marchand.maven.saxon.utils.SaxonOptions;

@Mojo(name="run-xspec", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class XSpecMojo
extends AbstractMojo
implements LogProvider {
    public static final transient String XSPEC_PREFIX = "dependency://io.xspec+xspec/";
    public static final transient String XML_UTILITIES_PREFIX = "dependency://org.mricaud+xml-utilities/";
    public static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final transient String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    public static final transient String LOCAL_PREFIX = "dependency://io.xspec.maven+xspec-maven-plugin/";
    @Component
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(property="skipTests", defaultValue="false")
    public boolean skipTests;
    @Parameter
    public String xspecXslCompiler;
    @Parameter
    public String xspecXQueryCompiler;
    @Parameter
    public String schIsoDsdlInclude;
    @Parameter
    public String schIsoAbstractExpand;
    @Parameter
    public String schIsoSvrlForXslt2;
    @Parameter
    public String schSchut;
    @Parameter
    public String xspecReporter;
    @Parameter
    public String junitReporter;
    @Parameter
    public String coverageReporter;
    @Parameter
    public String junitAggregator;
    @Parameter
    public String dependencyScanner;
    @Parameter(defaultValue="${project.basedir}/src/test/xspec", required=true)
    public File testDir;
    @Parameter(name="saxonOptions")
    public SaxonOptions saxonOptions;
    @Parameter(alias="excludes")
    public List<String> excludes;
    @Parameter(defaultValue="${maven.test.failure.ignore}")
    public boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/xspec-reports", required=true)
    public File reportDir;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    public File junitReportDir;
    @Parameter(defaultValue="${catalog.filename}")
    public String catalogFile;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    public File surefireReportDir;
    @Parameter(defaultValue="false")
    public Boolean generateSurefireReport;
    @Parameter(defaultValue="false")
    public Boolean keepGeneratedCatalog;
    @Parameter(defaultValue="false")
    private boolean coverage;
    @Parameter(defaultValue="false")
    private boolean folding;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    public MojoExecution execution;
    XmlStuff xmlStuff;
    boolean uriResolverSet = false;
    public static final QName QN_NAME = new QName("name");
    public static final QName QN_SELECT = new QName("select");
    static final String XSPEC_MOJO_PFX = "[xspec-mojo] ";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"'skipTests' is set... skipping XSpec tests!");
            return;
        }
        XSpecImplResources xspecResources = this.getXSpecResources();
        SchematronImplResources schResources = this.getSchematronResources();
        XSpecPluginResources pluginResources = this.getXSpecPluginResources();
        RunnerOptions options = new RunnerOptions(this.project.getBasedir(), this.keepGeneratedCatalog, this.catalogFile, this.excludes, this.testDir, this.reportDir, this.execution == null ? null : this.execution.getExecutionId(), this.surefireReportDir, this.coverage, this.folding);
        Properties environment = new Properties();
        environment.putAll((Map<?, ?>)this.session.getUserProperties());
        environment.putAll((Map<?, ?>)this.session.getSystemProperties());
        XSpecRunner runner = new XSpecRunner(this.getLog(), this.project.getBasedir());
        runner.setResources(xspecResources, schResources, pluginResources);
        runner.setEnvironment(environment, options);
        try {
            runner.init(this.saxonOptions);
            runner.execute();
        }
        catch (XSpecFailureException ex) {
            if (!this.testFailureIgnore) {
                throw new MojoFailureException("Some XSpec tests failed or were missed!");
            }
            this.getLog().warn((CharSequence)"Some XSpec tests failed or were missed, but build will not fail!");
        }
        catch (XSpecPluginException ex) {
            throw new MojoExecutionException("While running XSpecs", (Exception)ex);
        }
        finally {
            try {
                runner.generateIndex();
            }
            catch (XSpecPluginException ex) {}
        }
    }

    protected boolean isSkipTests() {
        return this.skipTests;
    }

    private XSpecImplResources getXSpecResources() {
        DefaultXSpecImplResources ret = new DefaultXSpecImplResources();
        if (this.xspecXslCompiler != null && !this.xspecXslCompiler.isEmpty()) {
            ret.setXSpecXslCompilerUri(this.xspecXslCompiler);
        }
        if (this.xspecXQueryCompiler != null && !this.xspecXQueryCompiler.isEmpty()) {
            ret.setXSpecXQueryCompiler(this.xspecXQueryCompiler);
        }
        if (this.schSchut != null && !this.schSchut.isEmpty()) {
            ret.setSchematronSchutConverter(this.schSchut);
        }
        if (this.xspecReporter != null && !this.xspecReporter.isEmpty()) {
            ret.setXSpecReporter(this.xspecReporter);
        }
        if (this.junitReporter != null && !this.junitReporter.isEmpty()) {
            ret.setJUnitReporter(this.junitReporter);
        }
        if (this.coverageReporter != null && !this.coverageReporter.isEmpty()) {
            ret.setXSpecCoverageReporter(this.coverageReporter);
        }
        return ret;
    }

    private SchematronImplResources getSchematronResources() {
        DefaultSchematronImplResources ret = new DefaultSchematronImplResources();
        if (this.schIsoDsdlInclude != null && !this.schIsoDsdlInclude.isEmpty()) {
            ret.setSchIsoDsdlInclude(this.schIsoDsdlInclude);
        }
        if (this.schIsoAbstractExpand != null && !this.schIsoAbstractExpand.isEmpty()) {
            ret.setSchIsoAbstractExpand(this.schIsoAbstractExpand);
        }
        if (this.schIsoSvrlForXslt2 != null && !this.schIsoSvrlForXslt2.isEmpty()) {
            ret.setSchIsoSvrlForXslt2(this.schIsoSvrlForXslt2);
        }
        return ret;
    }

    private XSpecPluginResources getXSpecPluginResources() {
        DefaultXSpecPluginResources ret = new DefaultXSpecPluginResources();
        if (this.junitAggregator != null && !this.junitAggregator.isEmpty()) {
            ret.setJunitAggregator(this.junitAggregator);
        }
        if (this.dependencyScanner != null && !this.dependencyScanner.isEmpty()) {
            ret.setDependencyScanner(this.dependencyScanner);
        }
        return ret;
    }
}

