/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.LogProvider;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.xml.sax.Attributes;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;

public class XSpecCounterCH
extends DefaultHandler2 {
    public static final String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    private int tests = 0;
    private int pendingTests = 0;
    private int pendingWrapper = 0;
    private boolean pendingScenario = true;
    private final LogProvider logProvider;
    private final String systemId;
    private final URIResolver uriResolver;
    private final boolean activateLogs;
    private final String LOG_PREFIX;
    private XSpecCounterCH importedTestFilter;

    public XSpecCounterCH(String systemId, URIResolver uriResolver, LogProvider logProvider, boolean activateLogs, String ... prefix) {
        this.systemId = systemId;
        this.uriResolver = uriResolver;
        this.logProvider = logProvider;
        this.activateLogs = activateLogs;
        this.LOG_PREFIX = prefix.length > 0 ? prefix[0] : "";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.activateLogs) {
            this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "startElement(" + uri + "," + localName + "," + qName + ",...)"));
        }
        if (XSPEC_NS.equals(uri) && ("pendingTests".equals(localName) || "pending".equals(localName))) {
            ++this.pendingWrapper;
        } else if (XSPEC_NS.equals(uri) && "scenario".equals(localName) && (atts.getValue("pendingTests") != null || atts.getValue("pending") != null)) {
            ++this.pendingWrapper;
            this.pendingScenario = true;
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "entering pending scenario"));
            }
        } else if (XSPEC_NS.equals(uri) && "expect".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "entering expect"));
            }
            if (this.pendingWrapper > 0) {
                ++this.pendingTests;
            }
            ++this.tests;
        } else if (XSPEC_NS.equals(uri) && "import".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "[in " + this.systemId + "] seeing imported XSpec " + atts.getValue("href")));
            }
            String importedSystemId = null;
            try {
                Source source = this.uriResolver.resolve(atts.getValue("href"), this.systemId);
                importedSystemId = source.getSystemId();
            }
            catch (TransformerException ex) {
                this.logProvider.getLog().error((CharSequence)("while resolving " + atts.getValue("href") + " to " + this.systemId), (Throwable)ex);
            }
            if (importedSystemId != null) {
                try {
                    if (this.activateLogs) {
                        this.logProvider.getLog().warn((CharSequence)(this.LOG_PREFIX + "[in " + this.systemId + "] parsing imported XSpec " + importedSystemId));
                    }
                    Parser parser = XmlStuff.PARSER_FACTORY.newSAXParser().getParser();
                    ParserAdapter reader = new ParserAdapter(parser);
                    this.importedTestFilter = new XSpecCounterCH(importedSystemId, this.uriResolver, this.logProvider, this.activateLogs, XSPEC_NS + importedSystemId + ": ");
                    XMLFilterImpl filter = new XMLFilterImpl(reader){

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                            super.startElement(uri, localName, qName, atts);
                            XSpecCounterCH.this.importedTestFilter.startElement(uri, localName, qName, atts);
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            super.endElement(uri, localName, qName);
                            XSpecCounterCH.this.importedTestFilter.endElement(uri, localName, qName);
                        }
                    };
                    filter.parse(importedSystemId);
                }
                catch (IOException | ParserConfigurationException | SAXException ex) {
                    this.logProvider.getLog().error((CharSequence)("[" + this.systemId + "] while counting into imported " + importedSystemId), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (XSPEC_NS.equals(uri) && ("pendingTests".equals(localName) || "pending".equals(localName))) {
            --this.pendingWrapper;
        } else if (XSPEC_NS.equals(uri) && "scenario".equals(localName) && this.pendingScenario) {
            --this.pendingWrapper;
            this.pendingScenario = false;
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "exiting pending scenario"));
            }
        } else if (XSPEC_NS.equals(uri) && "import".equals(localName)) {
            if (this.activateLogs) {
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "Adding " + this.importedTestFilter.getTests() + " tests"));
                this.logProvider.getLog().debug((CharSequence)(this.LOG_PREFIX + "Adding " + this.importedTestFilter.getPendingTests() + " pending tests"));
            }
            this.tests += this.importedTestFilter.getTests();
            this.pendingTests += this.importedTestFilter.getPendingTests();
            this.importedTestFilter = null;
        }
    }

    public int getTests() {
        return this.tests;
    }

    public int getPendingTests() {
        return this.pendingTests;
    }
}

