/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import io.xspec.maven.xspecMavenPlugin.utils.extenders.CatalogWriterExtender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.plexus.util.StringUtils;
import top.marchand.java.classpath.utils.ClasspathException;
import top.marchand.java.classpath.utils.ClasspathUtils;
import top.marchand.java.classpath.utils.NotFoundCallback;

public class CatalogWriter {
    private final ClasspathUtils cu;
    private CatalogWriterExtender catalogWriterExtender;
    private NotFoundCallback artifactNotFoundCallback;

    public CatalogWriter(ClassLoader cl) throws XSpecPluginException {
        try {
            this.cu = new ClasspathUtils(cl);
        }
        catch (ClasspathException ex) {
            throw new XSpecPluginException("while creating catalogBuilder", ex);
        }
    }

    public CatalogWriter(ClassLoader cl, CatalogWriterExtender ext) throws XSpecPluginException {
        this(cl);
        this.catalogWriterExtender = ext;
    }

    public void setNotFoundCallback(NotFoundCallback artifactNotFoundCallback) {
        this.artifactNotFoundCallback = artifactNotFoundCallback;
    }

    public File writeCatalog(String userCatalogFilename, Properties environment, boolean keepGeneratedCatalog) throws XSpecPluginException, IOException, IllegalArgumentException {
        if (userCatalogFilename != null && environment == null) {
            throw new IllegalArgumentException("If you specify a userCatalogFilename, you must provide a non null environment.");
        }
        File tmpCatalog = File.createTempFile("tmp", "-catalog.xml");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpCatalog), Charset.forName("UTF-8"));){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(osw);
            xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("catalog");
            xmlWriter.setDefaultNamespace("urn:oasis:names:tc:entity:xmlns:xml:catalog");
            xmlWriter.writeNamespace("", "urn:oasis:names:tc:entity:xmlns:xml:catalog");
            if (this.catalogWriterExtender != null) {
                this.catalogWriterExtender.beforeWrite(this, this.cu);
            }
            String jarUri = this.cu.getArtifactJarUri("io.xspec", "xspec");
            this.writeCatalogEntry(xmlWriter, jarUri, "dependency://io.xspec+xspec/");
            this.writeCatalogEntry(xmlWriter, jarUri, "dependency:/com.schematron+iso-schematron/");
            jarUri = this.cu.getArtifactJarUri("org.mricaud.xml", "xut");
            this.writeCatalogEntry(xmlWriter, jarUri, "dependency://org.mricaud+xml-utilities/");
            jarUri = this.cu.getArtifactJarUri("io.xspec.maven", "xspec-maven-plugin");
            this.writeCatalogEntry(xmlWriter, jarUri, "dependency://io.xspec.maven+xspec-maven-plugin/");
            if (userCatalogFilename != null) {
                xmlWriter.writeEmptyElement("nextCatalog");
                String catalogFilename = StringUtils.interpolate((String)userCatalogFilename, (Map)environment);
                try {
                    URI uri = new URI(catalogFilename);
                    if (uri.isAbsolute()) {
                        xmlWriter.writeAttribute("catalog", uri.toString());
                    } else {
                        xmlWriter.writeAttribute("catalog", new File(catalogFilename).toURI().toURL().toExternalForm());
                    }
                }
                catch (MalformedURLException | URISyntaxException | XMLStreamException ex) {
                    xmlWriter.writeAttribute("catalog", new File(catalogFilename).toURI().toURL().toExternalForm());
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            if (this.catalogWriterExtender != null) {
                this.catalogWriterExtender.afterWrite(this, this.cu);
            }
            osw.flush();
        }
        catch (XMLStreamException | ClasspathException ex) {
            System.err.println("while creating catalog, exception thrown: " + ex.getClass().getName());
            throw new XSpecPluginException("while creating catalog", ex);
        }
        catch (NullPointerException ex) {
            System.err.println("while creating catalog, NPE thrown: " + ex.getClass().getName());
            throw new XSpecPluginException("while creating catalog", ex);
        }
        if (!keepGeneratedCatalog) {
            tmpCatalog.deleteOnExit();
        }
        return tmpCatalog;
    }

    private void writeCatalogEntry(XMLStreamWriter xmlWriter, String jarUri, String prefix) throws XMLStreamException {
        xmlWriter.writeEmptyElement("rewriteURI");
        xmlWriter.writeAttribute("uriStartString", prefix);
        xmlWriter.writeAttribute("rewritePrefix", jarUri);
        xmlWriter.writeEmptyElement("rewriteSystem");
        xmlWriter.writeAttribute("uriStartString", prefix);
        xmlWriter.writeAttribute("rewritePrefix", jarUri);
    }
}

