/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin;

import com.jenitennison.xslt.tests.XSLTCoverageTraceListener;
import io.xspec.maven.xspecMavenPlugin.resources.SchematronImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecPluginResources;
import io.xspec.maven.xspecMavenPlugin.utils.CompiledXSpec;
import io.xspec.maven.xspecMavenPlugin.utils.FileFinder;
import io.xspec.maven.xspecMavenPlugin.utils.IndexGenerator;
import io.xspec.maven.xspecMavenPlugin.utils.LogProvider;
import io.xspec.maven.xspecMavenPlugin.utils.OwnErrorListener;
import io.xspec.maven.xspecMavenPlugin.utils.ProcessedFile;
import io.xspec.maven.xspecMavenPlugin.utils.RunnerOptions;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecCompiler;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecFailureException;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecResultsHandler;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecType;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import io.xspec.maven.xspecMavenPlugin.utils.extenders.CatalogWriterExtender;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.TeeDestination;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import top.marchand.maven.saxon.utils.SaxonOptions;

public class XSpecRunner
implements LogProvider {
    public static final String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    public static final String TRACE_SYS_PROP_IGNORE_DIR = "xspec.coverage.ignore";
    public static final String TRACE_SYS_PROP_COVERAGE_FILE = "xspec.coverage.xml";
    public static final String TRACE_SYS_PROP_XSPEC_FILE = "xspec.xspecfile";
    private final Log log;
    private final Configuration saxonConfiguration;
    private final File baseDirectory;
    private XSpecImplResources xspecResources;
    private SchematronImplResources schResources;
    private XSpecPluginResources pluginResources;
    private XmlStuff xmlStuff;
    private final Properties executionProperties;
    private RunnerOptions options;
    private boolean initDone;
    private List<ProcessedFile> processedFiles;
    private XSpecCompiler xspecCompiler;
    private CatalogWriterExtender catalogWriterExtender;
    public static final QName INITIAL_TEMPLATE_NAME = new QName("http://www.jenitennison.com/xslt/xspec", "main");
    public static final QName INLINE_CSS = new QName("inline-css");
    private static final String COVERAGE_ERROR_MESSAGE = "Coverage report is only available with Saxon-PE or Saxon-EE";
    private boolean failed;

    public XSpecRunner(Log log, File baseDirectory) {
        this.log = log;
        this.baseDirectory = baseDirectory;
        this.saxonConfiguration = XSpecRunner.getSaxonConfiguration();
        this.executionProperties = new Properties();
    }

    public XSpecRunner init(SaxonOptions saxonOptions) throws IllegalStateException, XSpecPluginException {
        if (this.initDone) {
            throw new IllegalStateException("init(SaxonOptions) has already been call");
        }
        if (this.xspecResources == null || this.schResources == null || this.pluginResources == null) {
            throw new IllegalStateException("setResources(XSpecImplResources,SchematronImplResources,XSpecPluginResources) must be call before init()");
        }
        this.getLog().debug((CharSequence)"Creating XmlStuff...");
        if (this.options == null) {
            this.getLog().debug((CharSequence)"options was null, creating a new one.");
            this.options = new RunnerOptions(this.baseDirectory);
        }
        try {
            this.xmlStuff = new XmlStuff(new Processor(this.saxonConfiguration), saxonOptions, this.getLog(), this.xspecResources, this.pluginResources, this.schResources, this.baseDirectory, this.options, this.executionProperties, this.catalogWriterExtender);
        }
        catch (XSpecPluginException ex) {
            this.getLog().error((CharSequence)"Exception while creating XmlStuff", (Throwable)ex);
            throw ex;
        }
        this.xspecCompiler = new XSpecCompiler(this.xmlStuff, this.options, this.log);
        this.initDone = true;
        return this;
    }

    public void execute() throws XSpecPluginException, XSpecFailureException {
        this.getLog().debug((CharSequence)("Looking for XSpecs in: " + this.options.testDir));
        List<File> xspecs = this.findAllXSpecs();
        this.getLog().info((CharSequence)("Found " + xspecs.size() + " XSpecs..."));
        this.failed = false;
        this.initProcessedFiles(xspecs.size());
        for (File xspec : xspecs) {
            try {
                if (this.processXSpec(xspec)) continue;
                this.failed = true;
            }
            catch (IOException | TransformerException | SaxonApiException ex) {
                this.failed = true;
                throw new XSpecFailureException("while processing " + xspec.getAbsolutePath(), ex);
            }
        }
        try {
            this.extractCssResource();
        }
        catch (IOException ex) {
            throw new XSpecPluginException("while extracting CSS", ex);
        }
        if (this.failed) {
            throw new XSpecPluginException("Some XSpec tests failed or were missed!");
        }
    }

    final boolean processXSpec(File xspec) throws SaxonApiException, TransformerException, IOException {
        this.getLog().info((CharSequence)("Processing XSpec: " + xspec.getAbsolutePath()));
        XdmNode xspecDocument = this.xmlStuff.getDocumentBuilder().build(xspec);
        XSpecType type = this.getXSpecType(xspecDocument);
        switch (type) {
            case XQ: {
                return this.processXQueryXSpec(xspecDocument);
            }
            case SCH: {
                XdmNode compiledSchXSpec = this.xspecCompiler.prepareSchematronDocument(xspecDocument);
                return this.processXsltXSpec(compiledSchXSpec);
            }
        }
        return this.processXsltXSpec(xspecDocument);
    }

    final boolean processXQueryXSpec(XdmNode xspec) throws SaxonApiException, FileNotFoundException, IOException {
        XSpecResultsHandler resultsHandler;
        CompiledXSpec compiledXSpec;
        File sourceFile;
        block11: {
            sourceFile = new File(xspec.getBaseURI());
            compiledXSpec = this.xspecCompiler.compileXSpecForXQuery(sourceFile);
            if (compiledXSpec == null) {
                this.getLog().error((CharSequence)("unable to compile " + sourceFile.getAbsolutePath()));
                return false;
            }
            this.getLog().debug((CharSequence)("XQuery compiled XSpec is at " + compiledXSpec.getCompiledStylesheet().getAbsolutePath()));
            resultsHandler = new XSpecResultsHandler();
            boolean processedFileAdded = false;
            try {
                XQueryExecutable xeXSpec = this.xmlStuff.getXqueryCompiler().compile((InputStream)new FileInputStream(compiledXSpec.getCompiledStylesheet()));
                XQueryEvaluator xtXSpec = xeXSpec.load();
                this.getLog().info((CharSequence)("Executing XQuery XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
                File xspecXmlResult = this.xspecCompiler.getXSpecXmlResultPath(this.options.reportDir, sourceFile);
                Serializer xmlSerializer = this.xmlStuff.getProcessor().newSerializer();
                xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                xmlSerializer.setOutputFile(xspecXmlResult);
                File xspecHtmlResult = this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile);
                Serializer htmlSerializer = this.xmlStuff.getProcessor().newSerializer();
                htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
                htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                htmlSerializer.setOutputFile(xspecHtmlResult);
                XsltTransformer reporter = this.xmlStuff.getReporter().load();
                reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
                reporter.setDestination((Destination)htmlSerializer);
                Serializer xtSurefire = null;
                if (this.xmlStuff.getXeSurefire() != null) {
                    XsltTransformer xt = this.xmlStuff.getXeSurefire().load();
                    try {
                        xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.baseDirectory.toURI().toURL().toExternalForm()));
                        xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.options.surefireReportDir.toURI().toURL().toExternalForm()));
                        xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                        xt.setDestination((Destination)this.xmlStuff.newSerializer((OutputStream)new NullOutputStream()));
                        xtSurefire = xt;
                    }
                    catch (MalformedURLException ex) {
                        this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                    }
                } else {
                    xtSurefire = this.xmlStuff.newSerializer((OutputStream)new NullOutputStream());
                }
                ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, xspecHtmlResult);
                this.processedFiles.add(pf);
                processedFileAdded = true;
                String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + "resources/test-report.css";
                reporter.setParameter(XmlStuff.QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(relativeCssPath));
                TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)reporter);
                StreamSource xspecSource = new StreamSource(sourceFile);
                xtXSpec.setSource((Source)xspecSource);
                xtXSpec.setURIResolver(this.xmlStuff.getUriResolver());
                XdmValue result = xtXSpec.evaluate();
                if (result == null) {
                    this.getLog().debug((CharSequence)"processXQueryXSpec result is null");
                } else {
                    this.getLog().debug((CharSequence)("processXQueryXSpec result : " + result.toString()));
                    this.xmlStuff.getProcessor().writeXdmValue(result, (Destination)destination);
                }
            }
            catch (SaxonApiException te) {
                this.getLog().error((CharSequence)te.getMessage());
                this.getLog().debug((Throwable)te);
                if (processedFileAdded) break block11;
                ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile));
                this.processedFiles.add(pf);
            }
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", sourceFile.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    final boolean processXsltXSpec(XdmNode xspec) throws SaxonApiException, FileNotFoundException {
        String value;
        File actualSourceFile;
        File sourceFile = actualSourceFile = new File(xspec.getBaseURI());
        XPathSelector xps = this.xmlStuff.getXPathCompiler().compile("/x:description/@xspec-original-location").load();
        xps.setContextItem((XdmItem)xspec);
        XdmItem item = xps.evaluateSingle();
        if (item != null && !(value = item.getStringValue()).isEmpty()) {
            try {
                sourceFile = new File(new URI(value));
            }
            catch (URISyntaxException ex) {
                this.getLog().error((CharSequence)"This should never be possible ! Check /x:description/@xspec-original-location", (Throwable)ex);
            }
        }
        this.getLog().debug((CharSequence)("sourceFile is " + sourceFile.getAbsolutePath()));
        boolean wasItAnXSpecOnSchematron = !sourceFile.equals(actualSourceFile);
        CompiledXSpec compiledXSpec = this.xspecCompiler.compileXSpecForXslt(actualSourceFile);
        if (compiledXSpec == null) {
            return false;
        }
        this.getLog().info((CharSequence)"XSpec has been compiled");
        OwnErrorListener errorListener = new OwnErrorListener(this.getLog());
        XsltExecutable xeXSpec = this.xmlStuff.compileXsl(new StreamSource(compiledXSpec.getCompiledStylesheet()));
        XsltTransformer xtXSpec = xeXSpec.load();
        xtXSpec.setErrorListener((ErrorListener)errorListener);
        if (wasItAnXSpecOnSchematron || !this.options.coverage.booleanValue()) {
            this.getLog().info((CharSequence)("coverage not activated for " + sourceFile.getName()));
            this.getLog().debug((CharSequence)("wasItAnXSpecOnSchematron: " + wasItAnXSpecOnSchematron));
            this.getLog().debug((CharSequence)("options.coverage: " + this.options.coverage));
            return this.runXsltXspecWithoutCoverage(sourceFile, actualSourceFile, xtXSpec, compiledXSpec, errorListener);
        }
        this.getLog().info((CharSequence)("coverage activated for " + sourceFile.getName()));
        return this.runXsltXspecWithCoverage(sourceFile, actualSourceFile, xtXSpec, compiledXSpec, errorListener);
    }

    private boolean runXsltXspecWithoutCoverage(File sourceFile, File actualSourceFile, XsltTransformer xtXSpec, CompiledXSpec compiledXSpec, ErrorListener errorListener) throws SaxonApiException, FileNotFoundException {
        boolean processedFileAdded = false;
        XSpecResultsHandler resultsHandler = new XSpecResultsHandler();
        try {
            xtXSpec.setInitialTemplate(INITIAL_TEMPLATE_NAME);
            this.getLog().info((CharSequence)("Executing XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
            File xspecXmlResult = this.xspecCompiler.getXSpecXmlResultPath(this.options.reportDir, sourceFile);
            Serializer xmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            xmlSerializer.setOutputFile(xspecXmlResult);
            this.getLog().debug((CharSequence)"\txml report output set");
            File xspecHtmlResult = this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile);
            Serializer htmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
            htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            htmlSerializer.setOutputFile(xspecHtmlResult);
            XsltTransformer reporter = this.xmlStuff.getReporter().load();
            reporter.setErrorListener(errorListener);
            reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
            reporter.setDestination((Destination)htmlSerializer);
            this.getLog().debug((CharSequence)"\thtml report output set");
            Serializer xtSurefire = null;
            if (this.xmlStuff.getXeSurefire() != null) {
                XsltTransformer xt = this.xmlStuff.getXeSurefire().load();
                xt.setErrorListener(errorListener);
                try {
                    xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.baseDirectory.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.options.reportDir.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                    xt.setDestination((Destination)this.xmlStuff.newSerializer((OutputStream)new NullOutputStream()));
                    xtSurefire = xt;
                }
                catch (MalformedURLException ex) {
                    this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                }
            } else {
                xtSurefire = this.xmlStuff.newSerializer((OutputStream)new NullOutputStream());
            }
            this.getLog().debug((CharSequence)"\tsurefire report output set");
            this.getLog().debug((CharSequence)"\tcreating PF");
            ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, xspecHtmlResult);
            this.getLog().debug((CharSequence)"\tadding PF to list");
            this.processedFiles.add(pf);
            processedFileAdded = true;
            this.getLog().debug((CharSequence)"\tprocessedFile processed");
            String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + "resources/test-report.css";
            this.getLog().debug((CharSequence)("\trelativeCssPath: " + relativeCssPath));
            reporter.setParameter(XmlStuff.QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(relativeCssPath));
            TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)reporter);
            this.getLog().debug((CharSequence)"\tdestination tree constructed");
            XMLReader reader = XmlStuff.PARSER_FACTORY.newSAXParser().getXMLReader();
            reader.setEntityResolver((EntityResolver)((Object)this.xmlStuff.getUriResolver()));
            SAXSource xspecSource = new SAXSource(reader, new InputSource(new FileInputStream(sourceFile)));
            xspecSource.setSystemId(sourceFile.toURI().toString());
            xtXSpec.setSource((Source)xspecSource);
            xtXSpec.setURIResolver(this.xmlStuff.getUriResolver());
            xtXSpec.setDestination((Destination)destination);
            xtXSpec.setBaseOutputURI(xspecXmlResult.toURI().toString());
            this.getLog().debug((CharSequence)"\tlaunching transform");
            xtXSpec.transform();
            this.getLog().debug((CharSequence)"XSpec run");
        }
        catch (SaxonApiException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
            if (!processedFileAdded) {
                ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile));
                this.processedFiles.add(pf);
            }
        }
        catch (FileNotFoundException | ParserConfigurationException | SAXException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", sourceFile.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    private boolean runXsltXspecWithCoverage(File sourceFile, File actualSourceFile, XsltTransformer xtXSpec, CompiledXSpec compiledXSpec, ErrorListener errorListener) throws SaxonApiException, FileNotFoundException {
        boolean processedFileAdded = false;
        XSpecResultsHandler resultsHandler = new XSpecResultsHandler();
        try {
            File coverageFile = this.xspecCompiler.getCoverageTempPath(this.options.reportDir, sourceFile);
            this.getLog().debug((CharSequence)("coverage File: " + coverageFile.getAbsolutePath()));
            System.setProperty(TRACE_SYS_PROP_IGNORE_DIR, compiledXSpec.getCompiledStylesheet().getParentFile().getAbsolutePath());
            System.setProperty(TRACE_SYS_PROP_XSPEC_FILE, sourceFile.getAbsolutePath());
            System.setProperty(TRACE_SYS_PROP_COVERAGE_FILE, coverageFile.getAbsolutePath());
            try {
                XSLTCoverageTraceListener tl = new XSLTCoverageTraceListener();
                xtXSpec.setTraceListener((TraceListener)tl);
                this.getLog().info((CharSequence)"Trace listener is active");
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"while instanciating XSLTCoverageTraceListener", (Throwable)ex);
            }
            xtXSpec.setInitialTemplate(INITIAL_TEMPLATE_NAME);
            this.getLog().info((CharSequence)("Executing XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
            File xspecXmlResult = this.xspecCompiler.getXSpecXmlResultPath(this.options.reportDir, sourceFile);
            XMLReader reader = XmlStuff.PARSER_FACTORY.newSAXParser().getXMLReader();
            reader.setEntityResolver((EntityResolver)((Object)this.xmlStuff.getUriResolver()));
            SAXSource xspecSource = new SAXSource(reader, new InputSource(new FileInputStream(sourceFile)));
            xspecSource.setSystemId(sourceFile.toURI().toString());
            xtXSpec.setSource((Source)xspecSource);
            xtXSpec.setURIResolver(this.xmlStuff.getUriResolver());
            XdmDestination xspecResult = new XdmDestination();
            xtXSpec.setDestination((Destination)xspecResult);
            xtXSpec.setBaseOutputURI(xspecXmlResult.toURI().toString());
            this.getLog().debug((CharSequence)"\tlaunching transform");
            xtXSpec.transform();
            this.getLog().debug((CharSequence)"XSpec run");
            Serializer xmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            xmlSerializer.setOutputFile(xspecXmlResult);
            this.getLog().debug((CharSequence)"\txml report output set");
            File xspecHtmlResult = this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile);
            Serializer htmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
            htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            htmlSerializer.setOutputFile(xspecHtmlResult);
            XsltTransformer reporter = this.xmlStuff.getReporter().load();
            reporter.setErrorListener(errorListener);
            reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
            reporter.setDestination((Destination)htmlSerializer);
            this.getLog().debug((CharSequence)"\thtml report output set");
            Serializer xtSurefire = null;
            if (this.xmlStuff.getXeSurefire() != null) {
                XsltTransformer xt = this.xmlStuff.getXeSurefire().load();
                xt.setErrorListener(errorListener);
                try {
                    xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.baseDirectory.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.options.reportDir.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                    xt.setDestination((Destination)this.xmlStuff.newSerializer((OutputStream)new NullOutputStream()));
                    xtSurefire = xt;
                }
                catch (MalformedURLException ex) {
                    this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                }
            } else {
                xtSurefire = this.xmlStuff.newSerializer((OutputStream)new NullOutputStream());
            }
            this.getLog().debug((CharSequence)"\tsurefire report output set");
            this.getLog().debug((CharSequence)"\tcreating PF");
            ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, xspecHtmlResult);
            this.getLog().debug((CharSequence)"\tadding PF to list");
            this.processedFiles.add(pf);
            processedFileAdded = true;
            this.getLog().debug((CharSequence)"\tprocessedFile processed");
            String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + "resources/test-report.css";
            this.getLog().debug((CharSequence)("\trelativeCssPath: " + relativeCssPath));
            reporter.setParameter(XmlStuff.QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(relativeCssPath));
            TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)reporter);
            this.getLog().debug((CharSequence)"\tdestination tree constructed");
            this.xmlStuff.getProcessor().writeXdmValue((XdmValue)xspecResult.getXdmNode(), (Destination)destination);
            if (this.xmlStuff.getCoverageReporter() != null) {
                XsltTransformer coverage = this.xmlStuff.getCoverageReporter().load();
                coverage.setErrorListener(errorListener);
                File coverageReportFile = this.xspecCompiler.getCoverageFinalPath(this.options.reportDir, sourceFile);
                pf.setCoverageFile(coverageReportFile.toPath());
                coverage.setDestination((Destination)this.xmlStuff.getProcessor().newSerializer(coverageReportFile));
                coverage.setSource((Source)new StreamSource(coverageFile));
                coverage.setParameter(INLINE_CSS, (XdmValue)XdmAtomicValue.makeAtomicValue((Object)"false"));
                coverage.setParameter(XmlStuff.QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(relativeCssPath));
                coverage.transform();
            } else {
                this.getLog().warn((CharSequence)COVERAGE_ERROR_MESSAGE);
            }
        }
        catch (SaxonApiException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
            if (!processedFileAdded) {
                ProcessedFile pf = new ProcessedFile(this.options.testDir, sourceFile, this.options.reportDir, this.xspecCompiler.getXSpecHtmlResultPath(this.options.reportDir, sourceFile));
                this.processedFiles.add(pf);
            }
        }
        catch (FileNotFoundException | ParserConfigurationException | SAXException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", sourceFile.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            this.getLog().debug((CharSequence)"\tXSpec terminated, return false");
            return false;
        }
        this.getLog().info((CharSequence)msg);
        this.getLog().debug((CharSequence)"\tXSpec terminated, return true");
        return true;
    }

    XSpecType getXSpecType(XdmNode doc) throws SaxonApiException {
        XPathSelector xps = this.xmlStuff.getXpExecGetXSpecType().load();
        xps.setContextItem((XdmItem)doc);
        XdmValue values = xps.evaluate();
        Iterator o = values.iterator();
        if (o instanceof XdmSequenceIterator) {
            XdmSequenceIterator it = (XdmSequenceIterator)o;
            while (it.hasNext()) {
                String nodeName;
                XdmNode item = (XdmNode)it.next();
                if (!item.getNodeKind().equals((Object)XdmNodeKind.ATTRIBUTE)) continue;
                switch (nodeName = item.getNodeName().getLocalName()) {
                    case "query": 
                    case "query-at": {
                        return XSpecType.XQ;
                    }
                    case "schematron": {
                        return XSpecType.SCH;
                    }
                    case "stylesheet": {
                        return XSpecType.XSL;
                    }
                }
            }
        } else {
            Iterator it = o;
            while (it.hasNext()) {
                String nodeName;
                XdmNode item = (XdmNode)it.next();
                if (!item.getNodeKind().equals((Object)XdmNodeKind.ATTRIBUTE)) continue;
                switch (nodeName = item.getNodeName().getLocalName()) {
                    case "query": 
                    case "query-at": {
                        return XSpecType.XQ;
                    }
                    case "schematron": {
                        return XSpecType.SCH;
                    }
                    case "stylesheet": {
                        return XSpecType.XSL;
                    }
                }
            }
        }
        throw new SaxonApiException("This file does not seem to be a valid XSpec file: " + doc.getBaseURI().toString());
    }

    public XSpecRunner setResources(XSpecImplResources xspecResources, SchematronImplResources schResources, XSpecPluginResources pluginResources) {
        this.xspecResources = xspecResources;
        this.schResources = schResources;
        this.pluginResources = pluginResources;
        return this;
    }

    public XSpecRunner setEnvironment(Properties executionProperties, RunnerOptions options) {
        this.executionProperties.putAll((Map<?, ?>)executionProperties);
        this.options = options;
        return this;
    }

    public void generateIndex() throws XSpecPluginException {
        if (this.processedFiles == null) {
            throw new IllegalStateException("no execution has been done. processedFiles is null");
        }
        this.getLog().debug((CharSequence)("processedFiles is " + this.processedFiles.size() + " length"));
        IndexGenerator generator = new IndexGenerator(this.options, this.processedFiles, this.xmlStuff);
        generator.generateIndex();
    }

    private static Configuration getSaxonConfiguration() {
        Configuration ret = Configuration.newConfiguration();
        ret.setConfigurationProperty("http://saxon.sf.net/feature/allow-external-functions", (Object)Boolean.TRUE);
        return ret;
    }

    List<File> findAllXSpecs() throws XSpecPluginException {
        FileFinder finder = new FileFinder(this.options.testDir, "**/*.xspec", this.options.excludes, this.getLog());
        Path testPath = this.options.testDir.toPath();
        try {
            List<Path> found = finder.search();
            ArrayList<File> ret = new ArrayList<File>(found.size());
            found.stream().forEach(p -> {
                File resolved = testPath.resolve((Path)p).toFile();
                ret.add(resolved);
            });
            return ret;
        }
        catch (IOException ex) {
            throw new XSpecPluginException(ex);
        }
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    protected void extractCssResource() throws MalformedURLException, IOException {
        File cssFile = new File(this.options.reportDir, "resources/test-report.css");
        cssFile.getParentFile().mkdirs();
        try {
            Source cssSource = this.xmlStuff.getUriResolver().resolve(this.xspecResources.getXSpecCssReportUri(), this.baseDirectory.toURI().toURL().toExternalForm());
            BufferedInputStream is = new BufferedInputStream(new URL(cssSource.getSystemId()).openStream());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cssFile));
            byte[] buffer = new byte[1024];
            int read = is.read(buffer);
            while (read > 0) {
                bos.write(buffer, 0, read);
                read = is.read(buffer);
            }
        }
        catch (TransformerException ex) {
            this.getLog().error((CharSequence)"while extracting CSS: ", (Throwable)ex);
        }
    }

    XmlStuff getXmlStuff() {
        return this.xmlStuff;
    }

    public CatalogWriterExtender getCatalogWriterExtender() {
        return this.catalogWriterExtender;
    }

    public void setCatalogWriterExtender(CatalogWriterExtender catalogWriterExtender) {
        this.catalogWriterExtender = catalogWriterExtender;
    }

    void initProcessedFiles(int size) {
        this.processedFiles = new ArrayList<ProcessedFile>(size);
    }
}

