/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import io.xspec.maven.xspecMavenPlugin.resolver.Resolver;
import io.xspec.maven.xspecMavenPlugin.utils.ProcessedFile;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.TeeDestination;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;
import uk.org.adamretter.maven.CompiledXSpec;
import uk.org.adamretter.maven.LogProvider;
import uk.org.adamretter.maven.XSpecResultsHandler;
import uk.org.adamretter.maven.XSpecTestFilter;

@Mojo(name="run-xspec", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class XSpecMojo
extends AbstractMojo
implements LogProvider {
    public static final transient String XSPEC_PREFIX = "dependency://io.xspec+xspec/";
    public static final transient String XML_UTILITIES_PREFIX = "dependency://org.mricaud+xml-utilities/";
    public static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final transient String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    public static final transient String LOCAL_PREFIX = "dependency://io.xspec.maven+xspec-maven-plugin/";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(property="skipTests", defaultValue="false")
    public boolean skipTests;
    @Parameter(defaultValue="dependency://io.xspec+xspec/compiler/generate-xspec-tests.xsl", required=true)
    public String xspecXslCompiler;
    @Parameter(defaultValue="dependency://io.xspec+xspec/compiler/generate-query-tests.xsl", required=true)
    public String xspecXQueryCompiler;
    @Parameter(defaultValue="dependency://io.xspec+xspec/schematron/iso-schematron/iso_dsdl_include.xsl", required=true)
    public String schIsoDsdlInclude;
    @Parameter(defaultValue="dependency://io.xspec+xspec/schematron/iso-schematron/iso_abstract_expand.xsl", required=true)
    public String schIsoAbstractExpand;
    @Parameter(defaultValue="dependency://io.xspec+xspec/schematron/iso-schematron/iso_svrl_for_xslt2.xsl", required=true)
    public String schIsoSvrlForXslt2;
    @Parameter(defaultValue="dependency://io.xspec.maven+xspec-maven-plugin/schematron/schut-to-xspec.xsl", required=true)
    public String schSchut;
    @Parameter(defaultValue="dependency://io.xspec+xspec/reporter/format-xspec-report.xsl", required=true)
    public String xspecReporter;
    @Parameter(defaultValue="dependency://io.xspec+xspec/reporter/junit-report.xsl", required=true)
    public String junitReporter;
    @Parameter(defaultValue="dependency://io.xspec.maven+xspec-maven-plugin/io/xspec/maven/xspec-maven-plugin/junit-aggregator.xsl")
    public String junitAggregator;
    @Parameter(defaultValue="dependency://org.mricaud+xml-utilities/org/mricaud/xml-utilities/get-xml-file-static-dependency-tree.xsl")
    public String dependencyScanner;
    @Parameter(defaultValue="${project.basedir}/src/test/xspec", required=true)
    public File testDir;
    @Parameter(name="saxonOptions")
    public SaxonOptions saxonOptions;
    @Parameter(alias="excludes")
    public List<String> excludes;
    @Parameter(defaultValue="${maven.test.failure.skip}")
    public boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/xspec-reports", required=true)
    public File reportDir;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    public File junitReportDir;
    @Parameter(defaultValue="${catalog.filename}")
    public File catalogFile;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    public File surefireReportDir;
    @Parameter(defaultValue="false")
    public Boolean generateSurefireReport;
    @Parameter(defaultValue="false")
    public Boolean keepGeneratedCatalog;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    public MojoExecution execution;
    public static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    public static final Configuration SAXON_CONFIGURATION = XSpecMojo.getSaxonConfiguration();
    XmlStuff xmlStuff;
    boolean uriResolverSet = false;
    private List<ProcessedFile> processedFiles;
    private static final List<ProcessedFile> PROCESS_FILES = new ArrayList<ProcessedFile>();
    public static final QName INITIAL_TEMPLATE_NAME = QName.fromClarkName((String)"{http://www.jenitennison.com/xslt/xspec}main");
    private static URIResolver initialUriResolver;
    public static final QName QN_NAME;
    public static final QName QN_SELECT;
    public static final QName QN_STYLESHEET;
    public static final QName QN_TEST_DIR;
    public static final QName QN_URI;
    private List<File> filesToDelete;
    private List<File> junitFiles;
    static final String XSPEC_MOJO_PFX = "[xspec-mojo] ";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"'skipTests' is set... skipping XSpec tests!");
            return;
        }
        this.filesToDelete = new ArrayList<File>();
        this.junitFiles = new ArrayList<File>();
        try {
            this.prepareXmlUtilities();
            this.getLog().debug((CharSequence)("Looking for XSpecs in: " + this.getTestDir()));
            List<File> xspecs = this.findAllXSpecs(this.getTestDir());
            this.getLog().info((CharSequence)("Found " + xspecs.size() + " XSpecs..."));
            boolean failed = false;
            this.processedFiles = new ArrayList<ProcessedFile>(xspecs.size());
            for (File xspec : xspecs) {
                if (this.shouldExclude(xspec)) {
                    this.getLog().warn((CharSequence)("Skipping excluded XSpec: " + xspec.getAbsolutePath()));
                    continue;
                }
                if (this.processXSpec(xspec)) continue;
                failed = true;
            }
            File cssFile = new File(this.getReportDir(), "resources/test-report.css");
            cssFile.getParentFile().mkdirs();
            try {
                Source cssSource = this.xmlStuff.getUriResolver().resolve("dependency://io.xspec+xspec/reporter/test-report.css", this.project.getBasedir().toURI().toURL().toExternalForm());
                BufferedInputStream is = new BufferedInputStream(new URL(cssSource.getSystemId()).openStream());
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cssFile));
                byte[] buffer = new byte[1024];
                int read = is.read(buffer);
                while (read > 0) {
                    bos.write(buffer, 0, read);
                    read = is.read(buffer);
                }
            }
            catch (TransformerException ex) {
                this.getLog().error((CharSequence)"while extracting CSS: ", (Throwable)ex);
            }
            this.createJunitReport();
            if (failed) {
                if (!this.testFailureIgnore) {
                    throw new MojoFailureException("Some XSpec tests failed or were missed!");
                }
                this.getLog().warn((CharSequence)"Some XSpec tests failed or were missed, but build will not fail!");
            }
        }
        catch (IOException | TransformerException | SaxonApiException sae) {
            throw new MojoExecutionException(sae.getMessage(), (Exception)sae);
        }
        finally {
            if (this.processedFiles == null) {
                this.processedFiles = new ArrayList<ProcessedFile>();
            }
            PROCESS_FILES.addAll(this.processedFiles);
            this.generateIndex();
        }
    }

    protected void prepareXmlUtilities() throws MojoExecutionException, MojoFailureException, SaxonApiException, MalformedURLException, TransformerException {
        this.xmlStuff = new XmlStuff(new Processor(SAXON_CONFIGURATION), this.getLog());
        if (this.saxonOptions != null) {
            try {
                SaxonUtils.prepareSaxonConfiguration((Processor)this.xmlStuff.getProcessor(), (SaxonOptions)this.saxonOptions);
            }
            catch (XPathException ex) {
                this.getLog().error((Throwable)ex);
                throw new MojoExecutionException("Illegal value in Saxon configuration property", (Exception)((Object)ex));
            }
        }
        if (initialUriResolver == null) {
            initialUriResolver = this.xmlStuff.getUriResolver();
        }
        try {
            this.xmlStuff.doAdditionalConfiguration(this.saxonOptions);
        }
        catch (XPathException ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Illegal value in Saxon configuration property", (Exception)((Object)ex));
        }
        if (!this.uriResolverSet) {
            try {
                this.xmlStuff.setUriResolver(this.buildUriResolver(initialUriResolver));
                this.uriResolverSet = true;
            }
            catch (IOException | XMLStreamException | DependencyResolutionRequiredException ex) {
                throw new MojoExecutionException("while creating URI resolver", (Exception)ex);
            }
        }
        this.xmlStuff.setXpExecGetXSpecType(this.xmlStuff.getXPathCompiler().compile("/*/@*"));
        this.xmlStuff.setXpSchGetXSpecFile(this.xmlStuff.getXPathCompiler().compile("iri-to-uri(concat(replace(document-uri(/), '(.*)/.*$', '$1'), '/', /*[local-name() = 'description']/@schematron))"));
        this.xmlStuff.setXpFileSearcher(this.xmlStuff.getXPathCompiler().compile("//file[@dependency-type!='x:description']"));
        this.getLog().debug((CharSequence)("Using XSpec Xslt Compiler: " + this.getXspecXslCompiler()));
        this.getLog().debug((CharSequence)("Using XSpec Xquery Compiler: " + this.getXspecXQueryCompiler()));
        this.getLog().debug((CharSequence)("Using XSpec Reporter: " + this.getXspecReporter()));
        this.getLog().debug((CharSequence)("Using JUnit Reporter: " + this.getJUnitReporter()));
        this.getLog().debug((CharSequence)("Using Schematron Dsdl include: " + this.getSchematronIsoDsdl()));
        this.getLog().debug((CharSequence)("Using Schematron expander: " + this.getSchematronExpand()));
        this.getLog().debug((CharSequence)("Using Schematrong Svrl: " + this.getSchematronSvrForXslt()));
        this.getLog().debug((CharSequence)("Using Schematron schut: " + this.getSchematronSchut()));
        this.getLog().debug((CharSequence)("Using XML dependency scanner: " + this.getXmlDependencyScanner()));
        String baseUri = this.project != null ? this.project.getBasedir().toURI().toURL().toExternalForm() : null;
        Source srcXsltCompiler = this.resolveSrc(this.getXspecXslCompiler(), baseUri, "XSpec XSL Compiler");
        this.getLog().debug((CharSequence)(this.getXspecXslCompiler() + " -> " + srcXsltCompiler.getSystemId()));
        Source srcXqueryCompiler = this.resolveSrc(this.getXspecXQueryCompiler(), baseUri, "XSpec XQuery Compiler");
        this.getLog().debug((CharSequence)(this.getXspecXQueryCompiler() + " -> " + srcXqueryCompiler.getSystemId()));
        Source srcReporter = this.resolveSrc(this.getXspecReporter(), baseUri, "XSpec Reporter");
        this.getLog().debug((CharSequence)(this.getXspecReporter() + " -> " + srcReporter.getSystemId()));
        Source srcJUnitReporter = this.resolveSrc(this.getJUnitReporter(), baseUri, "JUnit Reporter");
        this.getLog().debug((CharSequence)(this.getJUnitReporter() + " -> " + srcJUnitReporter.getSystemId()));
        Source srcSchIsoDsdl = this.resolveSrc(this.getSchematronIsoDsdl(), baseUri, "Schematron Dsdl");
        this.getLog().debug((CharSequence)(this.getSchematronIsoDsdl() + " -> " + srcSchIsoDsdl.getSystemId()));
        Source srcSchExpand = this.resolveSrc(this.getSchematronExpand(), baseUri, "Schematron expander");
        this.getLog().debug((CharSequence)(this.getSchematronExpand() + " -> " + srcSchExpand.getSystemId()));
        Source srcSchSvrl = this.resolveSrc(this.getSchematronSvrForXslt(), baseUri, "Schematron Svrl");
        this.getLog().debug((CharSequence)(this.getSchematronSvrForXslt() + " -> " + srcSchSvrl.getSystemId()));
        Source srcSchSchut = this.resolveSrc(this.getSchematronSchut(), baseUri, "Schematron Schut");
        this.getLog().debug((CharSequence)(this.getSchematronSchut() + " -> " + srcSchSchut.getSystemId()));
        Source xmlDependencyScanner = this.resolveSrc(this.getXmlDependencyScanner(), baseUri, "Xml dependency scanner");
        this.getLog().debug((CharSequence)(this.getXmlDependencyScanner() + " -> " + xmlDependencyScanner.getSystemId()));
        this.xmlStuff.setXspec4xsltCompiler(this.xmlStuff.compileXsl(srcXsltCompiler));
        this.xmlStuff.setXspec4xqueryCompiler(this.xmlStuff.compileXsl(srcXqueryCompiler));
        this.xmlStuff.setReporter(this.xmlStuff.compileXsl(srcReporter));
        this.xmlStuff.setJUnitReporter(this.xmlStuff.compileXsl(srcJUnitReporter));
        this.xmlStuff.setSchematronDsdl(this.xmlStuff.compileXsl(srcSchIsoDsdl));
        this.xmlStuff.setSchematronExpand(this.xmlStuff.compileXsl(srcSchExpand));
        this.xmlStuff.setSchematronSvrl(this.xmlStuff.compileXsl(srcSchSvrl));
        this.xmlStuff.setSchematronSchut(this.xmlStuff.compileXsl(srcSchSchut));
        this.xmlStuff.setXmlDependencyScanner(this.xmlStuff.compileXsl(xmlDependencyScanner));
        if (this.generateSurefireReport.booleanValue()) {
            this.xmlStuff.setXeSurefire(this.xmlStuff.compileXsl(new StreamSource(this.getClass().getResourceAsStream("/surefire-reporter.xsl"))));
        }
    }

    private Source resolveSrc(String source, String baseUri, String desc) throws MojoExecutionException, TransformerException {
        Source ret = this.xmlStuff.getUriResolver().resolve(source, baseUri);
        if (ret == null) {
            throw new MojoExecutionException("Could not find " + desc + " stylesheet in: " + source);
        }
        return ret;
    }

    private void generateIndex() {
        File index = new File(this.reportDir, "index.html");
        if (!this.reportDir.exists()) {
            this.reportDir.mkdirs();
        }
        try (BufferedWriter fos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(index), Charset.forName("UTF-8")));){
            fos.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
            fos.write("<html>");
            fos.write("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            fos.write("<style>\n\ttable {border: solid black 1px; border-collapse: collapse; }\n");
            fos.write("\ttr.error {background-color: red; color: white; }\n");
            fos.write("\ttr.error td a { color: white;}\n");
            fos.write("\ttr.title {background-color: lightgrey; }\n");
            fos.write("\ttd,th {border: solid black 1px; }\n");
            fos.write("\ttd:not(:first-child) {text-align: right; }\n");
            fos.write("</style>\n");
            fos.write("<title>XSpec results</title><meta name=\"date\" content=\"");
            fos.write(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            fos.write("\"></head>\n");
            fos.write("<body><h3>XSpec results</h3>");
            fos.write("<table><thead><tr><th>XSpec file</th><th>Passed</th><th>Pending</th><th>Failed</th><th>Missed</th><th>Total</th></tr></thead>\n");
            fos.write("<tbody>");
            String lastRootDir = "";
            for (ProcessedFile pf : PROCESS_FILES) {
                int errorCount;
                String rootDir = pf.getRootSourceDir().toString();
                if (!lastRootDir.equals(rootDir)) {
                    fos.write("<tr class=\"title\"><td colspan=\"6\">");
                    fos.write(rootDir);
                    fos.write("</td></tr>\n");
                    lastRootDir = rootDir;
                }
                if ((errorCount = pf.getFailed() + pf.getMissed()) == 0) {
                    fos.write("<tr>");
                } else {
                    fos.write("<tr class=\"error\">");
                }
                fos.write("<td><a href=\"");
                fos.write(pf.getReportFile().toUri().toString());
                fos.write("\">" + pf.getRelativeSourcePath() + "</a></td>");
                fos.write("<td>" + pf.getPassed() + "</td>");
                fos.write("<td>" + pf.getPending() + "</td>");
                fos.write("<td>" + pf.getFailed() + "</td>");
                fos.write("<td>" + pf.getMissed() + "</td>");
                fos.write("<td>" + pf.getTotal() + "</td>");
                fos.write("</tr>\n");
            }
            fos.write("</tbody></table>");
            fos.write("</body></html>");
            fos.flush();
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"while writing XSpec index file", (Throwable)ex);
        }
    }

    private boolean shouldExclude(File xspec) {
        List<String> excludePatterns = this.getExcludes();
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                if (!xspec.getAbsolutePath().replaceAll("\\\\", "/").endsWith(excludePattern)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean processXSpec(File xspec) throws SaxonApiException, TransformerException, IOException {
        this.getLog().info((CharSequence)("Processing XSpec: " + xspec.getAbsolutePath()));
        XdmNode xspecDocument = this.xmlStuff.getDocumentBuilder().build(xspec);
        XSpecType type = this.getXSpecType(xspecDocument);
        switch (type) {
            case XQ: {
                return this.processXQueryXSpec(xspecDocument);
            }
            case SCH: {
                XdmNode compiledSchXSpec = this.prepareSchematronDocument(xspecDocument);
                return this.processXsltXSpec(compiledSchXSpec);
            }
        }
        return this.processXsltXSpec(xspecDocument);
    }

    final boolean processXsltXSpec(XdmNode xspec) throws SaxonApiException, FileNotFoundException {
        String value;
        File actualSourceFile;
        File sourceFile = actualSourceFile = new File(xspec.getBaseURI());
        XPathSelector xps = this.xmlStuff.getXPathCompiler().compile("/x:description/@xspec-original-location").load();
        xps.setContextItem((XdmItem)xspec);
        XdmItem item = xps.evaluateSingle();
        if (item != null && !(value = item.getStringValue()).isEmpty()) {
            try {
                sourceFile = new File(new URI(value));
            }
            catch (URISyntaxException ex) {
                this.getLog().error((CharSequence)"This should never be possible ! Check /x:description/@xspec-original-location", (Throwable)ex);
            }
        }
        this.getLog().debug((CharSequence)("sourceFile is " + sourceFile.getAbsolutePath()));
        CompiledXSpec compiledXSpec = this.compileXSpecForXslt(actualSourceFile);
        if (compiledXSpec == null) {
            return false;
        }
        XSpecResultsHandler resultsHandler = new XSpecResultsHandler(this);
        try {
            XsltExecutable xeXSpec = this.xmlStuff.compileXsl(new StreamSource(compiledXSpec.getCompiledStylesheet()));
            XsltTransformer xtXSpec = xeXSpec.load();
            xtXSpec.setInitialTemplate(INITIAL_TEMPLATE_NAME);
            this.getLog().info((CharSequence)("Executing XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
            File xspecXmlResult = this.getXSpecXmlResultPath(this.getReportDir(), sourceFile);
            Serializer xmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            xmlSerializer.setOutputFile(xspecXmlResult);
            File xspecHtmlResult = this.getXSpecHtmlResultPath(this.getReportDir(), sourceFile);
            Serializer htmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
            htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            htmlSerializer.setOutputFile(xspecHtmlResult);
            XsltTransformer reporter = this.xmlStuff.getReporter().load();
            reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
            reporter.setDestination((Destination)htmlSerializer);
            Serializer xtSurefire = null;
            if (this.xmlStuff.getXeSurefire() != null) {
                XsltTransformer xt = this.xmlStuff.getXeSurefire().load();
                try {
                    xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.project.getBasedir().toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.surefireReportDir.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                    xt.setDestination((Destination)this.xmlStuff.newSerializer((OutputStream)new NullOutputStream()));
                    xtSurefire = xt;
                }
                catch (MalformedURLException ex) {
                    this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                }
            } else {
                xtSurefire = this.xmlStuff.newSerializer((OutputStream)new NullOutputStream());
            }
            XsltTransformer juReporter = this.xmlStuff.getJUnitReporter().load();
            File junitFile = this.getJUnitReportPath(this.getReportDir(), sourceFile);
            Serializer junitDest = this.xmlStuff.newSerializer(new FileOutputStream(junitFile));
            junitDest.setOutputProperty(Serializer.Property.INDENT, "yes");
            juReporter.setDestination((Destination)junitDest);
            this.junitFiles.add(junitFile);
            ProcessedFile pf = new ProcessedFile(this.testDir, sourceFile, this.reportDir, xspecHtmlResult);
            this.processedFiles.add(pf);
            String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + "resources/test-report.css";
            reporter.setParameter(new QName("report-css-uri"), (XdmValue)new XdmAtomicValue(relativeCssPath));
            TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)new TeeDestination((Destination)reporter, (Destination)juReporter));
            xtXSpec.setDestination((Destination)destination);
            xtXSpec.setBaseOutputURI(xspecXmlResult.toURI().toString());
            StreamSource xspecSource = new StreamSource(sourceFile);
            xtXSpec.setSource((Source)xspecSource);
            xtXSpec.setURIResolver(this.xmlStuff.getUriResolver());
            xtXSpec.transform();
        }
        catch (SaxonApiException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", sourceFile.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    final boolean processXQueryXSpec(XdmNode xspec) throws SaxonApiException, FileNotFoundException, IOException {
        File sourceFile = new File(xspec.getBaseURI());
        CompiledXSpec compiledXSpec = this.compileXSpecForXQuery(sourceFile);
        if (compiledXSpec == null) {
            this.getLog().error((CharSequence)("unable to compile " + sourceFile.getAbsolutePath()));
            return false;
        }
        this.getLog().debug((CharSequence)("XQuery compiled XSpec is at " + compiledXSpec.getCompiledStylesheet().getAbsolutePath()));
        XSpecResultsHandler resultsHandler = new XSpecResultsHandler(this);
        try {
            XQueryExecutable xeXSpec = this.xmlStuff.getXqueryCompiler().compile((InputStream)new FileInputStream(compiledXSpec.getCompiledStylesheet()));
            XQueryEvaluator xtXSpec = xeXSpec.load();
            this.getLog().info((CharSequence)("Executing XQuery XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
            File xspecXmlResult = this.getXSpecXmlResultPath(this.getReportDir(), sourceFile);
            Serializer xmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            xmlSerializer.setOutputFile(xspecXmlResult);
            File xspecHtmlResult = this.getXSpecHtmlResultPath(this.getReportDir(), sourceFile);
            Serializer htmlSerializer = this.xmlStuff.getProcessor().newSerializer();
            htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
            htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            htmlSerializer.setOutputFile(xspecHtmlResult);
            XsltTransformer reporter = this.xmlStuff.getReporter().load();
            reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
            reporter.setDestination((Destination)htmlSerializer);
            Serializer xtSurefire = null;
            if (this.xmlStuff.getXeSurefire() != null) {
                XsltTransformer xt = this.xmlStuff.getXeSurefire().load();
                try {
                    xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.project.getBasedir().toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.surefireReportDir.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                    xt.setDestination((Destination)this.xmlStuff.newSerializer((OutputStream)new NullOutputStream()));
                    xtSurefire = xt;
                }
                catch (MalformedURLException ex) {
                    this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                }
            } else {
                xtSurefire = this.xmlStuff.newSerializer((OutputStream)new NullOutputStream());
            }
            ProcessedFile pf = new ProcessedFile(this.testDir, sourceFile, this.reportDir, xspecHtmlResult);
            this.processedFiles.add(pf);
            String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + "resources/test-report.css";
            reporter.setParameter(new QName("report-css-uri"), (XdmValue)new XdmAtomicValue(relativeCssPath));
            XsltTransformer juReporter = this.xmlStuff.getJUnitReporter().load();
            File junitFile = this.getJUnitReportPath(this.getReportDir(), sourceFile);
            Serializer junitDest = this.xmlStuff.newSerializer(new FileOutputStream(junitFile));
            junitDest.setOutputProperty(Serializer.Property.INDENT, "yes");
            juReporter.setDestination((Destination)junitDest);
            this.junitFiles.add(junitFile);
            TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)new TeeDestination((Destination)reporter, (Destination)juReporter));
            StreamSource xspecSource = new StreamSource(sourceFile);
            xtXSpec.setSource((Source)xspecSource);
            xtXSpec.setURIResolver(this.xmlStuff.getUriResolver());
            XdmValue result = xtXSpec.evaluate();
            if (result == null) {
                this.getLog().debug((CharSequence)"processXQueryXSpec result is null");
            } else {
                this.getLog().debug((CharSequence)("processXQueryXSpec result : " + result.toString()));
                this.xmlStuff.getProcessor().writeXdmValue(result, (Destination)destination);
            }
        }
        catch (SaxonApiException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", sourceFile.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    final CompiledXSpec compileXSpecForXQuery(File sourceFile) {
        return this.compileXSpec(sourceFile, this.xmlStuff.getXspec4xqueryCompiler());
    }

    final CompiledXSpec compileXSpecForXslt(File sourceFile) {
        return this.compileXSpec(sourceFile, this.xmlStuff.getXspec4xsltCompiler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompiledXSpec compileXSpec(File sourceFile, XsltExecutable compilerExec) {
        XsltTransformer compiler = compilerExec.load();
        InputStream isXSpec = null;
        try {
            File compiledXSpec = this.getCompiledXSpecPath(this.getReportDir(), sourceFile);
            this.getLog().info((CharSequence)("Compiling XSpec to XSLT: " + compiledXSpec));
            isXSpec = new FileInputStream(sourceFile);
            SAXParser parser = PARSER_FACTORY.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XSpecTestFilter xspecTestFilter = new XSpecTestFilter(reader, sourceFile.toURI().toString(), this.xmlStuff.getUriResolver(), this, false, new String[0]);
            InputSource inXSpec = new InputSource(isXSpec);
            inXSpec.setSystemId(sourceFile.getAbsolutePath());
            compiler.setSource((Source)new SAXSource(xspecTestFilter, inXSpec));
            Serializer serializer = this.xmlStuff.getProcessor().newSerializer();
            serializer.setOutputFile(compiledXSpec);
            compiler.setDestination((Destination)serializer);
            compiler.transform();
            CompiledXSpec compiledXSpec2 = new CompiledXSpec(xspecTestFilter.getTests(), xspecTestFilter.getPendingTests(), compiledXSpec);
            return compiledXSpec2;
        }
        catch (SaxonApiException sae) {
            this.getLog().error((CharSequence)sae.getMessage());
            this.getLog().debug((Throwable)sae);
        }
        catch (FileNotFoundException | ParserConfigurationException pce) {
            this.getLog().error((Throwable)pce);
        }
        catch (SAXException saxe) {
            this.getLog().error((CharSequence)saxe.getMessage());
            this.getLog().debug((Throwable)saxe);
        }
        finally {
            if (isXSpec != null) {
                try {
                    isXSpec.close();
                }
                catch (IOException ioe) {
                    this.getLog().warn((Throwable)ioe);
                }
            }
        }
        return null;
    }

    protected XdmNode prepareSchematronDocument(XdmNode xspecDocument) throws SaxonApiException, TransformerException, IOException {
        XsltTransformer step1 = this.xmlStuff.getSchematronDsdl().load();
        XsltTransformer step2 = this.xmlStuff.getSchematronExpand().load();
        XsltTransformer step3 = this.xmlStuff.getSchematronSvrl().load();
        XPathSelector xp = this.xmlStuff.getXPathCompiler().compile("/x:description/x:param[@name='phase'][1]/text()").load();
        xp.setContextItem((XdmItem)xspecDocument);
        XdmItem phaseItem = xp.evaluateSingle();
        if (phaseItem != null) {
            String phase = phaseItem.getStringValue();
            this.getLog().debug((CharSequence)("Evaluating phase: " + phase));
            if (phase != null && !phase.isEmpty()) {
                step3.setParameter(new QName("phase"), (XdmValue)new XdmAtomicValue(phase));
            }
        }
        step3.setParameter(new QName("allow-foreign"), (XdmValue)new XdmAtomicValue(true));
        File sourceFile = new File(xspecDocument.getBaseURI());
        step1.setDestination((Destination)step2);
        step2.setDestination((Destination)step3);
        File compiledSchematronDest = this.getCompiledSchematronPath(this.getReportDir(), sourceFile);
        Serializer serializer = this.xmlStuff.newSerializer(new FileOutputStream(compiledSchematronDest));
        step3.setDestination((Destination)serializer);
        XPathSelector xpSchemaPath = this.xmlStuff.getXPathCompiler().compile("/*/@schematron").load();
        xpSchemaPath.setContextItem((XdmItem)xspecDocument);
        String schematronPath = xpSchemaPath.evaluateSingle().getStringValue();
        Source source = this.xmlStuff.getUriResolver().resolve(schematronPath, xspecDocument.getBaseURI().toString());
        step1.setInitialContextNode(this.xmlStuff.getDocumentBuilder().build(source));
        step1.transform();
        this.getLog().debug((CharSequence)("Schematron compiled ! " + compiledSchematronDest.getAbsolutePath()));
        XsltTransformer schut = this.xmlStuff.getSchematronSchut().load();
        schut.setParameter(QN_STYLESHEET, (XdmValue)new XdmAtomicValue(compiledSchematronDest.toURI().toString()));
        schut.setParameter(QN_TEST_DIR, (XdmValue)new XdmAtomicValue(this.testDir.toURI().toString()));
        schut.setInitialContextNode(xspecDocument);
        File resultFile = this.getCompiledXspecSchematronPath(this.getReportDir(), sourceFile);
        schut.setDestination((Destination)this.xmlStuff.newSerializer(new FileOutputStream(resultFile)));
        schut.transform();
        this.getLog().debug((CharSequence)("XSpec for schematron compiled: " + resultFile.getAbsolutePath()));
        XdmNode result = this.xmlStuff.getDocumentBuilder().build(resultFile);
        if (!resultFile.exists()) {
            this.getLog().error((CharSequence)(resultFile.getAbsolutePath() + " has not be written"));
        }
        this.getLog().info((CharSequence)"Copying resource files referenced from XSpec for Schematron");
        XsltTransformer xslDependencyScanner = this.xmlStuff.getXmlDependencyScanner().load();
        XdmDestination xdmDest = new XdmDestination();
        xslDependencyScanner.setDestination((Destination)xdmDest);
        xslDependencyScanner.setInitialContextNode(xspecDocument);
        xslDependencyScanner.transform();
        XPathSelector xpFile = this.xmlStuff.getXpFileSearcher().load();
        xpFile.setContextItem((XdmItem)xdmDest.getXdmNode());
        XdmValue ret = xpFile.evaluate();
        for (int i = 0; i < ret.size(); ++i) {
            XdmNode node = (XdmNode)ret.itemAt(i);
            String uri = node.getAttributeValue(QN_URI);
            try {
                this.copyFile(xspecDocument.getUnderlyingNode().getSystemId(), uri, resultFile);
                continue;
            }
            catch (URISyntaxException ex) {
                throw new SaxonApiException("Saxon has generated an invalid URI : ", (Throwable)ex);
            }
        }
        return result;
    }

    protected void copyFile(String baseUri, String referencedFile, File resultBase) throws IOException, URISyntaxException {
        this.getLog().debug((CharSequence)("copyFile(" + baseUri + ", " + referencedFile + ", " + resultBase.getAbsolutePath() + ")"));
        Path basePath = new File(new URI(baseUri)).getParentFile().toPath();
        File source = basePath.resolve(referencedFile).toFile();
        File dest = resultBase.getParentFile().toPath().resolve(referencedFile).toFile();
        this.getLog().debug((CharSequence)("Copying " + source.getAbsolutePath() + " to " + dest.getAbsolutePath()));
        FileUtils.copyFile((File)source, (File)dest);
    }

    final File getCompiledXSpecPath(File xspecReportDir, File xspec) {
        return this.getCompiledPath(xspecReportDir, xspec, "xslt", ".xslt");
    }

    final File getCompiledSchematronPath(File xspecReportDir, File schematron) {
        File ret = this.getCompiledPath(xspecReportDir, schematron, "schematron", ".xslt");
        return ret;
    }

    final File getCompiledXspecSchematronPath(File xspecReportDir, File xspec) {
        File ret = this.getCompiledPath(xspecReportDir, xspec, FilenameUtils.getBaseName((String)xspec.getName()), "-compiled.xspec");
        this.filesToDelete.add(ret);
        return ret;
    }

    private File getCompiledPath(File xspecReportDir, File xspec, String name, String extension) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        Path relativeSource = this.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.execution != null && this.execution.getExecutionId() != null && !"default".equals(this.execution.getExecutionId()) ? new File(xspecReportDir, this.execution.getExecutionId()) : xspecReportDir;
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        File fCompiledDir = new File(outputDir, name);
        if (!fCompiledDir.exists()) {
            fCompiledDir.mkdirs();
        }
        return new File(fCompiledDir, xspec.getName() + extension);
    }

    final File getXSpecXmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "xml");
    }

    final File getXSpecHtmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "html");
    }

    final File getXSpecResultPath(File xspecReportDir, File xspec, String extension) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        Path relativeSource = this.testDir.toPath().relativize(xspec.toPath());
        this.getLog().debug((CharSequence)("executionId=" + this.execution.getExecutionId()));
        this.getLog().debug((CharSequence)("relativeSource=" + relativeSource.toString()));
        File executionReportDir = this.execution != null && this.execution.getExecutionId() != null && !"default".equals(this.execution.getExecutionId()) ? new File(xspecReportDir, this.execution.getExecutionId()) : xspecReportDir;
        executionReportDir.mkdirs();
        this.getLog().debug((CharSequence)("executionReportDir=" + executionReportDir.getAbsolutePath()));
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        this.getLog().debug((CharSequence)("outputDir=" + outputDir.getAbsolutePath()));
        return new File(outputDir, xspec.getName().replace(".xspec", "") + "." + extension);
    }

    final File getJUnitReportPath(File xspecReportDir, File xspec) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        Path relativeSource = this.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.execution != null && this.execution.getExecutionId() != null && !"default".equals(this.execution.getExecutionId()) ? new File(xspecReportDir, this.execution.getExecutionId()) : xspecReportDir;
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        return new File(outputDir, "junit-" + xspec.getName().replace(".xspec", "") + ".xml");
    }

    private List<File> findAllXSpecs(File xspecTestDir) {
        ArrayList<File> specs = new ArrayList<File>();
        if (xspecTestDir.exists()) {
            File[] specFiles = xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xspec");
                }
            });
            specs.addAll(Arrays.asList(specFiles));
            for (File subDir : xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                specs.addAll(this.findAllXSpecs(subDir));
            }
        }
        return specs;
    }

    protected boolean isSkipTests() {
        return this.skipTests;
    }

    protected String getXspecXslCompiler() {
        return this.xspecXslCompiler;
    }

    protected String getXspecXQueryCompiler() {
        return this.xspecXQueryCompiler;
    }

    protected String getXspecReporter() {
        return this.xspecReporter;
    }

    protected String getJUnitReporter() {
        return this.junitReporter;
    }

    protected String getSchematronIsoDsdl() {
        return this.schIsoDsdlInclude;
    }

    protected String getSchematronExpand() {
        return this.schIsoAbstractExpand;
    }

    protected String getSchematronSvrForXslt() {
        return this.schIsoSvrlForXslt2;
    }

    protected String getSchematronSchut() {
        return this.schSchut;
    }

    protected String getXmlDependencyScanner() {
        return this.dependencyScanner;
    }

    protected File getReportDir() {
        return this.reportDir;
    }

    protected File getTestDir() {
        return this.testDir;
    }

    protected List<String> getExcludes() {
        return this.excludes;
    }

    private String getJarUri(String groupId, String artifactId) throws IOException, MojoFailureException {
        String thisJar = null;
        String marker = this.createMarker(groupId, artifactId);
        this.getLog().debug((CharSequence)("marker=" + marker));
        for (String s : this.getClassPathElements()) {
            if (!s.contains(marker)) continue;
            thisJar = s;
            break;
        }
        if (thisJar == null) {
            throw new MojoFailureException("Unable to locate xspec jar file from classpath-");
        }
        String jarUri = this.makeJarUri(thisJar);
        return jarUri;
    }

    private URIResolver buildUriResolver(URIResolver saxonUriResolver) throws DependencyResolutionRequiredException, IOException, XMLStreamException, MojoFailureException {
        File tmpCatalog = File.createTempFile("tmp", "-catalog.xml");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpCatalog), Charset.forName("UTF-8"));){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(osw);
            xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("catalog");
            xmlWriter.setDefaultNamespace(CATALOG_NS);
            xmlWriter.writeNamespace("", CATALOG_NS);
            String jarUri = this.getJarUri("io.xspec", "xspec");
            this.writeCatalogEntry(xmlWriter, jarUri, XSPEC_PREFIX);
            jarUri = this.getJarUri("io.xspec.maven", "xspec-maven-plugin");
            this.writeCatalogEntry(xmlWriter, jarUri, XML_UTILITIES_PREFIX);
            jarUri = this.getJarUri("io.xspec.maven", "xspec-maven-plugin");
            this.writeCatalogEntry(xmlWriter, jarUri, LOCAL_PREFIX);
            if (this.catalogFile != null) {
                xmlWriter.writeEmptyElement("nextCatalog");
                xmlWriter.writeAttribute("catalog", this.catalogFile.toURI().toURL().toExternalForm());
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            osw.flush();
        }
        if (!this.keepGeneratedCatalog.booleanValue()) {
            tmpCatalog.deleteOnExit();
        } else {
            this.getLog().info((CharSequence)("keeping generated catalog: " + tmpCatalog.toURI().toURL().toExternalForm()));
        }
        return new Resolver(saxonUriResolver, tmpCatalog, this.getLog());
    }

    private void writeCatalogEntry(XMLStreamWriter xmlWriter, String jarUri, String prefix) throws XMLStreamException {
        xmlWriter.writeEmptyElement("rewriteURI");
        xmlWriter.writeAttribute("uriStartString", prefix);
        xmlWriter.writeAttribute("rewritePrefix", jarUri);
        xmlWriter.writeEmptyElement("rewriteSystem");
        xmlWriter.writeAttribute("uriStartString", prefix);
        xmlWriter.writeAttribute("rewritePrefix", jarUri);
    }

    private String makeJarUri(String jarFile) throws MalformedURLException {
        this.getLog().debug((CharSequence)String.format("makeJarUri(%s)", jarFile));
        return "jar:" + jarFile + "!/";
    }

    private List<String> getClassPathElements() throws MojoFailureException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            ArrayList<String> ret = new ArrayList<String>(ucl.getURLs().length);
            for (URL u : ucl.getURLs()) {
                ret.add(u.toExternalForm());
            }
            return ret;
        }
        throw new MojoFailureException("classloader is not a URL classloader : " + cl.getClass().getName());
    }

    private String createMarker(String groupId, String artifactId) throws IOException {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties"));
        return String.format("%s-%s", props.getProperty("artifactId"), props.getProperty("version"));
    }

    private void createJunitReport() throws MalformedURLException, TransformerException, SaxonApiException {
        String baseUri = this.project != null ? this.project.getBasedir().toURI().toURL().toExternalForm() : null;
        XsltTransformer xsl = this.xmlStuff.compileXsl(this.xmlStuff.getUriResolver().resolve(this.junitAggregator, baseUri)).load();
        xsl.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.testDir.toURI().toString()));
        StringBuilder sb = new StringBuilder("<files>");
        for (File f : this.junitFiles) {
            sb.append("<file>").append(f.toURI().toString()).append("</file>");
        }
        sb.append("</files>");
        xsl.setSource((Source)new StreamSource((InputStream)new ReaderInputStream((Reader)new StringReader(sb.toString()))));
        String fileName = this.execution != null && this.execution.getExecutionId() != null ? "TEST-xspec-" + this.execution.getExecutionId() + ".xml" : "TEST-xspec.xml";
        Serializer ser = this.xmlStuff.getProcessor().newSerializer(new File(this.junitReportDir, fileName));
        ser.setOutputProperty(Serializer.Property.INDENT, "yes");
        xsl.setDestination((Destination)ser);
        xsl.setMessageListener(new MessageListener(){

            public void message(XdmNode xn, boolean bln, SourceLocator sl) {
                XSpecMojo.this.getLog().debug((CharSequence)xn.getStringValue());
            }
        });
        xsl.transform();
    }

    private static Configuration getSaxonConfiguration() {
        Configuration ret = Configuration.newConfiguration();
        ret.setConfigurationProperty("http://saxon.sf.net/feature/allow-external-functions", (Object)Boolean.TRUE);
        return ret;
    }

    XSpecType getXSpecType(XdmNode doc) throws SaxonApiException {
        XPathSelector xps = this.xmlStuff.getXpExecGetXSpecType().load();
        xps.setContextItem((XdmItem)doc);
        XdmValue values = xps.evaluate();
        for (XdmNode item : values) {
            String nodeName;
            if (!item.getNodeKind().equals((Object)XdmNodeKind.ATTRIBUTE)) continue;
            switch (nodeName = item.getNodeName().getLocalName()) {
                case "query": 
                case "query-at": {
                    return XSpecType.XQ;
                }
                case "schematron": {
                    return XSpecType.SCH;
                }
                case "stylesheet": {
                    return XSpecType.XSL;
                }
            }
        }
        throw new SaxonApiException("This file does not seem to be a valid XSpec file: " + doc.getBaseURI().toString());
    }

    static {
        QN_NAME = new QName("name");
        QN_SELECT = new QName("select");
        QN_STYLESHEET = new QName("stylesheet");
        QN_TEST_DIR = new QName("test_dir");
        QN_URI = new QName("uri");
    }

    public static enum XSpecType {
        XSL,
        SCH,
        XQ;

    }
}

