/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.logging.Log;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;
import uk.org.adamretter.maven.XSpecMojo;

public class XmlStuff {
    private final Processor processor;
    private final DocumentBuilder documentBuilder;
    private final XsltCompiler xsltCompiler;
    private final XQueryCompiler xqueryCompiler;
    private final XPathCompiler xpathCompiler;
    private XsltExecutable xspec4xsltCompiler;
    private XsltExecutable xspec4xqueryCompiler;
    private XsltExecutable reporter;
    private XsltExecutable junitReporter;
    private XsltExecutable xeSurefire;
    private XsltExecutable schDsdl;
    private XsltExecutable schExpand;
    private XsltExecutable schSvrl;
    private XsltExecutable xmlDependencyScanner;
    private XPathExecutable xpExecGetXSpecType;
    private XPathExecutable xpFileSearcher;
    public static final QName QN_REPORT_CSS = new QName("report-css-uri");
    public static final String RESOURCES_TEST_REPORT_CSS = "resources/test-report.css";
    private XPathExecutable xpSchGetXSpec;
    private XsltExecutable schSchut;
    private final Log log;

    public XmlStuff(Processor processor, Log log) {
        this.processor = processor;
        this.documentBuilder = processor.newDocumentBuilder();
        this.xsltCompiler = processor.newXsltCompiler();
        this.xpathCompiler = processor.newXPathCompiler();
        this.xpathCompiler.declareNamespace("x", "http://www.jenitennison.com/xslt/xspec");
        this.xqueryCompiler = processor.newXQueryCompiler();
        this.log = log;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            try {
                Enumeration<URL> enumer = ucl.findResources("META-INF/services/top.marchand.xml.gaulois.xml");
                while (enumer.hasMoreElements()) {
                    URL url = enumer.nextElement();
                    log.debug((CharSequence)("loading service " + url.toExternalForm()));
                    XdmNode document = this.documentBuilder.build((Source)new StreamSource(url.openStream()));
                    XPathSelector selector = this.xpathCompiler.compile("/gaulois-services/saxon/extensions/function").load();
                    selector.setContextItem((XdmItem)document);
                    XdmSequenceIterator it = selector.evaluate().iterator();
                    while (it.hasNext()) {
                        String className = it.next().getStringValue();
                        try {
                            Class<?> clazz = Class.forName(className);
                            if (this.extendsClass(clazz, ExtensionFunctionDefinition.class)) {
                                Class<?> cle = clazz;
                                XSpecMojo.SAXON_CONFIGURATION.registerExtensionFunction((ExtensionFunctionDefinition)cle.newInstance());
                                log.debug((CharSequence)(className + "registered as Saxon extension function"));
                                continue;
                            }
                            log.warn((CharSequence)(className + " does not extends " + ExtensionFunctionDefinition.class.getName()));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                            log.warn((CharSequence)("unable to load extension function " + className));
                        }
                    }
                }
            }
            catch (IOException | SaxonApiException ex) {
                log.error((CharSequence)"while looking for resources in /META-INF/services/top.marchand.xml.gaulois/", ex);
            }
        }
    }

    public XsltExecutable compileXsl(Source source) throws SaxonApiException {
        try {
            return this.getXsltCompiler().compile(source);
        }
        catch (NullPointerException ex) {
            this.log.error((CharSequence)("while compiling XSL " + source.getSystemId()));
            return null;
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    private XsltCompiler getXsltCompiler() {
        return this.xsltCompiler;
    }

    public XPathCompiler getXPathCompiler() {
        return this.xpathCompiler;
    }

    public XsltExecutable getXspec4xsltCompiler() {
        return this.xspec4xsltCompiler;
    }

    public void setXspec4xsltCompiler(XsltExecutable xspec4xsltCompiler) {
        this.xspec4xsltCompiler = xspec4xsltCompiler;
    }

    public XsltExecutable getXspec4xqueryCompiler() {
        return this.xspec4xqueryCompiler;
    }

    public void setXspec4xqueryCompiler(XsltExecutable xspec4xqueryCompiler) {
        this.xspec4xqueryCompiler = xspec4xqueryCompiler;
    }

    public XsltExecutable getReporter() {
        return this.reporter;
    }

    public void setReporter(XsltExecutable reporter) {
        this.reporter = reporter;
    }

    public XsltTransformer getXtReporter() {
        XsltTransformer ret = this.getReporter().load();
        ret.setParameter(QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(RESOURCES_TEST_REPORT_CSS));
        return ret;
    }

    public XPathExecutable getXpExecGetXSpecType() {
        return this.xpExecGetXSpecType;
    }

    public void setXpExecGetXSpecType(XPathExecutable xpExecGetXSpecType) {
        this.xpExecGetXSpecType = xpExecGetXSpecType;
    }

    public URIResolver getUriResolver() {
        return this.xsltCompiler.getURIResolver();
    }

    public void setUriResolver(URIResolver urr) {
        this.xsltCompiler.setURIResolver(urr);
    }

    public XsltExecutable getXeSurefire() {
        return this.xeSurefire;
    }

    public void setXeSurefire(XsltExecutable xeSurefire) {
        this.xeSurefire = xeSurefire;
    }

    public Serializer newSerializer(OutputStream os) {
        return this.getProcessor().newSerializer(os);
    }

    public XQueryCompiler getXqueryCompiler() {
        return this.xqueryCompiler;
    }

    public void doAdditionalConfiguration(SaxonOptions saxonOptions) throws XPathException {
        if (saxonOptions != null) {
            SaxonUtils.configureXsltCompiler((XsltCompiler)this.getXsltCompiler(), (SaxonOptions)saxonOptions);
        }
    }

    public void setSchematronDsdl(XsltExecutable xe) {
        this.schDsdl = xe;
    }

    public void setSchematronExpand(XsltExecutable xe) {
        this.schExpand = xe;
    }

    public void setSchematronSvrl(XsltExecutable xe) {
        this.schSvrl = xe;
    }

    public XsltExecutable getSchematronDsdl() {
        return this.schDsdl;
    }

    public XsltExecutable getSchematronExpand() {
        return this.schExpand;
    }

    public XsltExecutable getSchematronSvrl() {
        return this.schSvrl;
    }

    public void setXpSchGetXSpecFile(XPathExecutable xe) {
        this.xpSchGetXSpec = xe;
    }

    public XPathExecutable getXpSchGetXSpecFile() {
        return this.xpSchGetXSpec;
    }

    public void setSchematronSchut(XsltExecutable xe) {
        this.schSchut = xe;
    }

    public XsltExecutable getSchematronSchut() {
        return this.schSchut;
    }

    public XsltExecutable getXmlDependencyScanner() {
        return this.xmlDependencyScanner;
    }

    public void setXmlDependencyScanner(XsltExecutable xmlDependencyScanner) {
        this.xmlDependencyScanner = xmlDependencyScanner;
    }

    public XPathExecutable getXpFileSearcher() {
        return this.xpFileSearcher;
    }

    public void setXpFileSearcher(XPathExecutable xpFileSearcher) {
        this.xpFileSearcher = xpFileSearcher;
    }

    private boolean extendsClass(Class toCheck, Class inheritor) {
        if (toCheck.equals(inheritor)) {
            return true;
        }
        if (toCheck.equals(Object.class)) {
            return false;
        }
        return this.extendsClass(toCheck.getSuperclass(), inheritor);
    }

    public void setJUnitReporter(XsltExecutable xe) {
        this.junitReporter = xe;
    }

    public XsltExecutable getJUnitReporter() {
        return this.junitReporter;
    }
}

