/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;

public class AnyURIDatatype {
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final QName QN = new QName("http://www.w3.org/2001/XMLSchema", "anyURI+");
    private final StringConverter converter = BuiltInAtomicType.ANY_URI.getStringConverter(ConversionRules.DEFAULT);

    public boolean isAtomic() {
        return true;
    }

    public boolean allowsMultiple() {
        return true;
    }

    public boolean allowsEmpty() {
        return false;
    }

    public XdmValue convert(String input, Configuration configuration) throws ValidationException {
        String[] values;
        if (input == null && this.allowsEmpty()) {
            return XdmValue.wrap(null);
        }
        if (input == null) {
            throw new ValidationException(QN.toString() + " does not allow empty sequence", (Location)ExplicitLocation.UNKNOWN_LOCATION);
        }
        String sValue = input.trim();
        if (sValue.startsWith("(") && sValue.endsWith(")")) {
            sValue = sValue.substring(1, sValue.length() - 1);
        }
        if ((values = sValue.split("[ ]*,[ ]*")).length > 1 && this.allowsMultiple()) {
            XdmValue xValue = null;
            for (String value : values) {
                XdmValue ret = XdmValue.wrap((Sequence)this.converter.convertString((CharSequence)value).asAtomic());
                xValue = xValue == null ? ret : xValue.append(ret);
            }
            return xValue;
        }
        if (values.length == 1) {
            return XdmValue.wrap((Sequence)this.converter.convertString((CharSequence)values[0]).asAtomic());
        }
        throw new ValidationException("can not cat " + input + " to " + QN.toString(), (Location)ExplicitLocation.UNKNOWN_LOCATION);
    }
}

