/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.resolver;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.maven.plugin.logging.Log;
import org.xmlresolver.Catalog;
import org.xmlresolver.CatalogSource;

public class Resolver
implements URIResolver {
    private final URIResolver saxonResolver;
    private final Log log;
    org.xmlresolver.Resolver cr;

    public Resolver(URIResolver saxonResolver, File catalog, Log log) {
        this.saxonResolver = saxonResolver;
        this.log = log;
        this.cr = new org.xmlresolver.Resolver(new Catalog());
        this.cr.getCatalog().addSource((CatalogSource)new CatalogSource.UriCatalogSource(catalog.toURI().toString()));
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            Source source = this.cr.resolve(href, base);
            if (source != null && source.getSystemId() != null) {
                return source;
            }
            source = this.saxonResolver.resolve(href, base);
            if (source != null && source.getSystemId() != null) {
                return source;
            }
            this.getLog().error((CharSequence)String.format("fail to resolve (%s, %s)", href, base));
            return null;
        }
        catch (TransformerException ex) {
            this.getLog().error((CharSequence)("Resolver.resolve(" + href + "," + base + ")"), (Throwable)ex);
            throw ex;
        }
    }

    private Log getLog() {
        return this.log;
    }
}

