/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import io.xspec.maven.xspecMavenPlugin.resolver.Resolver;
import io.xspec.maven.xspecMavenPlugin.utils.ProcessedFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.TeeDestination;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;
import uk.org.adamretter.maven.CompiledXSpec;
import uk.org.adamretter.maven.LogProvider;
import uk.org.adamretter.maven.XSpecResultsHandler;
import uk.org.adamretter.maven.XSpecTestFilter;

@Mojo(name="run-xspec", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class XSpecMojo
extends AbstractMojo
implements LogProvider {
    public static final transient String XSPEC_PREFIX = "xspec:/";
    public static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(defaultValue="xspec:/xspec/compiler/generate-xspec-tests.xsl", required=true)
    private String xspecCompiler;
    @Parameter(defaultValue="xspec:/xspec/reporter/format-xspec-report.xsl", required=true)
    private String xspecReporter;
    @Parameter(defaultValue="${project.basedir}/src/test/xspec", required=true)
    private File testDir;
    @Parameter(name="saxonOptions")
    private SaxonOptions saxonOptions;
    @Parameter(alias="excludes")
    private List<String> excludes;
    @Parameter(defaultValue="${project.build.directory}/xspec-reports", required=true)
    private File reportDir;
    @Parameter(defaultValue="${catalog.filename}")
    private File catalogFile;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    private File surefireReportDir;
    @Parameter(defaultValue="false")
    private Boolean generateSurefireReport;
    @Parameter(defaultValue="false")
    private Boolean keepGeneratedCatalog;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;
    public static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final Configuration SAXON_CONFIGURATION = XSpecMojo.getSaxonConfiguration();
    private Processor PROCESSOR = null;
    private XsltCompiler xsltCompiler = null;
    private boolean uriResolverSet = false;
    private List<ProcessedFile> processedFiles;
    private static final List<ProcessedFile> PROCESS_FILES = new ArrayList<ProcessedFile>();
    private static final QName INITIAL_TEMPLATE_NAME = QName.fromClarkName((String)"{http://www.jenitennison.com/xslt/xspec}main");
    private static URIResolver initialUriResolver;
    private static final String RESOURCES_TEST_REPORT_CSS = "resources/test-report.css";
    static final String XSPEC_MOJO_PFX = "[xspec-mojo] ";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.PROCESSOR = new Processor(SAXON_CONFIGURATION);
        if (this.saxonOptions != null) {
            try {
                SaxonUtils.prepareSaxonConfiguration((Processor)this.PROCESSOR, (SaxonOptions)this.saxonOptions);
            }
            catch (XPathException ex) {
                this.getLog().error((Throwable)ex);
                throw new MojoExecutionException("Illegal value in Saxon configuration property", (Exception)((Object)ex));
            }
        }
        this.xsltCompiler = this.PROCESSOR.newXsltCompiler();
        if (initialUriResolver == null) {
            initialUriResolver = this.xsltCompiler.getURIResolver();
        }
        if (this.saxonOptions != null) {
            try {
                SaxonUtils.configureXsltCompiler((XsltCompiler)this.xsltCompiler, (SaxonOptions)this.saxonOptions);
            }
            catch (XPathException ex) {
                this.getLog().error((Throwable)ex);
                throw new MojoExecutionException("Illegal value in Saxon configuration property", (Exception)((Object)ex));
            }
        }
        if (!this.uriResolverSet) {
            try {
                this.xsltCompiler.setURIResolver(this.buildUriResolver(initialUriResolver));
                this.uriResolverSet = true;
            }
            catch (IOException | XMLStreamException | DependencyResolutionRequiredException ex) {
                this.getLog().error((CharSequence)"while building URIResolver: ", ex);
                throw new MojoExecutionException("while creating URI resolver", (Exception)ex);
            }
        }
        URIResolver resolver = this.xsltCompiler.getURIResolver();
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"'skipTests' is set... skipping XSpec tests!");
            return;
        }
        String compilerPath = this.getXspecCompiler();
        this.getLog().debug((CharSequence)("Using XSpec Compiler: " + compilerPath));
        String reporterPath = this.getXspecReporter();
        this.getLog().debug((CharSequence)("Using XSpec Reporter: " + reporterPath));
        try {
            String baseUri = this.project.getBasedir().toURI().toURL().toExternalForm();
            Source srcCompiler = resolver.resolve(compilerPath, baseUri);
            if (srcCompiler == null) {
                throw new MojoExecutionException("Could not find XSpec Compiler stylesheets in: " + compilerPath);
            }
            Source srcReporter = resolver.resolve(reporterPath, baseUri);
            if (srcReporter == null) {
                throw new MojoExecutionException("Could not find XSpec Reporter stylesheets in: " + reporterPath);
            }
            this.getLog().debug((CharSequence)("Compiling " + srcCompiler.getSystemId()));
            XsltExecutable xeCompiler = null;
            try {
                xeCompiler = this.xsltCompiler.compile(srcCompiler);
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)("Failed to compile " + srcCompiler.getSystemId()), t);
            }
            this.getLog().debug((CharSequence)"\tCompiled");
            this.getLog().debug((CharSequence)("Compiling " + srcReporter.getSystemId()));
            XsltExecutable xeReporter = null;
            try {
                xeReporter = this.xsltCompiler.compile(srcReporter);
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)("Failed to compile " + srcReporter.getSystemId()), t);
            }
            this.getLog().debug((CharSequence)"\tCompiled");
            XsltTransformer xtReporter = xeReporter.load();
            xtReporter.setParameter(new QName("report-css-uri"), (XdmValue)new XdmAtomicValue(RESOURCES_TEST_REPORT_CSS));
            this.getLog().debug((CharSequence)("Looking for XSpecs in: " + this.getTestDir()));
            List<File> xspecs = this.findAllXSpecs(this.getTestDir());
            this.getLog().info((CharSequence)("Found " + xspecs.size() + " XSpecs..."));
            XsltExecutable xeSurefire = null;
            if (this.generateSurefireReport.booleanValue()) {
                XsltCompiler compiler = this.PROCESSOR.newXsltCompiler();
                xeSurefire = compiler.compile((Source)new StreamSource(this.getClass().getResourceAsStream("/surefire-reporter.xsl")));
            }
            boolean failed = false;
            this.processedFiles = new ArrayList<ProcessedFile>(xspecs.size());
            for (File xspec : xspecs) {
                if (this.shouldExclude(xspec)) {
                    this.getLog().warn((CharSequence)("Skipping excluded XSpec: " + xspec.getAbsolutePath()));
                    continue;
                }
                if (this.processXSpec(xspec, xeCompiler, xtReporter, xeSurefire, resolver)) continue;
                failed = true;
            }
            File cssFile = new File(this.getReportDir(), RESOURCES_TEST_REPORT_CSS);
            cssFile.getParentFile().mkdirs();
            try {
                Source cssSource = resolver.resolve("xspec:/xspec/reporter/test-report.css", baseUri);
                BufferedInputStream is = new BufferedInputStream(new URL(cssSource.getSystemId()).openStream());
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cssFile));
                byte[] buffer = new byte[1024];
                int read = is.read(buffer);
                while (read > 0) {
                    bos.write(buffer, 0, read);
                    read = is.read(buffer);
                }
            }
            catch (IOException | TransformerException ex) {
                this.getLog().error((CharSequence)"while extracting CSS: ", (Throwable)ex);
            }
            if (failed) {
                throw new MojoFailureException("Some XSpec tests failed or were missed!");
            }
        }
        catch (MalformedURLException | TransformerException | SaxonApiException sae) {
            this.getLog().info((CharSequence)"In catch");
            this.getLog().error((CharSequence)("Unable to compile the XSpec Compiler: " + compilerPath), sae);
            throw new MojoExecutionException(sae.getMessage(), (Exception)sae);
        }
        finally {
            PROCESS_FILES.addAll(this.processedFiles);
            this.generateIndex();
        }
    }

    private void generateIndex() {
        File index = new File(this.reportDir, "index.html");
        try (BufferedWriter fos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(index), Charset.forName("UTF-8")));){
            fos.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
            fos.write("<html>");
            fos.write("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            fos.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/test-report.css\"/>");
            fos.write("<style>\n\ttable {border:1px solid black; border-collapse:collapse; text-align:center;}\n");
            fos.write("\ttd,th {border:1px solid black; padding:2px;}\n");
            fos.write("\tth, td.zero{background-color:white;}\n");
            fos.write("</style>\n");
            fos.write("<title>XSpec results</title><meta name=\"date\" content=\"");
            fos.write(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            fos.write("\"></head>\n");
            fos.write("<body><h1>XSpec results</h1>");
            fos.write("<table>\n");
            fos.write("<colgroup><col/><col class=\"successful\"/><col class=\"pending\"/><col class=\"failed\"/><col class=\"missed\"/><col/></colgroup>\n");
            fos.write("<thead><tr><th>XSpec file</th><th>Passed</th><th>Pending</th><th>Failed</th><th>Missed</th><th>Total</th></tr></thead>\n");
            fos.write("<tbody>");
            String lastRootDir = "";
            for (ProcessedFile pf : PROCESS_FILES) {
                String rootDir = pf.getRootSourceDir().toString();
                if (!lastRootDir.equals(rootDir)) {
                    fos.write("<tr><td colspan=\"6\" style=\"text-align:left;\">");
                    fos.write(rootDir);
                    fos.write("</td></tr>\n");
                    lastRootDir = rootDir;
                }
                fos.write("<tr><td><a href=\"");
                fos.write(pf.getReportFile().toUri().toString());
                fos.write("\">" + pf.getRelativeSourcePath() + "</a></td>");
                fos.write("<td");
                if (pf.getPassed() == 0) {
                    fos.write(" class=\"zero\"");
                }
                fos.write(">" + pf.getPassed() + "</td>");
                fos.write("<td");
                if (pf.getPending() == 0) {
                    fos.write(" class=\"zero\"");
                }
                fos.write(">" + pf.getPending() + "</td>");
                fos.write("<td");
                if (pf.getFailed() == 0) {
                    fos.write(" class=\"zero\"");
                }
                fos.write(">" + pf.getFailed() + "</td>");
                fos.write("<td");
                if (pf.getMissed() == 0) {
                    fos.write(" class=\"zero\"");
                }
                fos.write(">" + pf.getMissed() + "</td>");
                fos.write("<td>" + pf.getTotal() + "</td>");
                fos.write("</tr>\n");
            }
            fos.write("</tbody></table>");
            fos.write("</body></html>");
            fos.flush();
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"while writing XSpec index file", (Throwable)ex);
        }
    }

    private boolean shouldExclude(File xspec) {
        List<String> excludePatterns = this.getExcludes();
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                if (!xspec.getAbsolutePath().endsWith(excludePattern)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean processXSpec(File xspec, XsltExecutable executable, XsltTransformer reporter, XsltExecutable xeSurefire, URIResolver uriResolver) {
        XSpecResultsHandler resultsHandler;
        CompiledXSpec compiledXSpec;
        block9: {
            this.getLog().info((CharSequence)("Processing XSpec: " + xspec.getAbsolutePath()));
            boolean processedFileAdded = false;
            compiledXSpec = this.compileXSpec(executable, xspec);
            if (compiledXSpec == null) {
                return false;
            }
            resultsHandler = new XSpecResultsHandler(this);
            try {
                XsltExecutable xeXSpec = this.xsltCompiler.compile((Source)new StreamSource(compiledXSpec.getCompiledStylesheet()));
                XsltTransformer xtXSpec = xeXSpec.load();
                xtXSpec.setInitialTemplate(INITIAL_TEMPLATE_NAME);
                this.getLog().info((CharSequence)("Executing XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
                File xspecXmlResult = this.getXSpecXmlResultPath(this.getReportDir(), xspec);
                Serializer xmlSerializer = this.PROCESSOR.newSerializer();
                xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                xmlSerializer.setOutputFile(xspecXmlResult);
                File xspecHtmlResult = this.getXSpecHtmlResultPath(this.getReportDir(), xspec);
                Serializer htmlSerializer = this.PROCESSOR.newSerializer();
                htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
                htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                htmlSerializer.setOutputFile(xspecHtmlResult);
                reporter.setBaseOutputURI(xspecHtmlResult.toURI().toString());
                reporter.setDestination((Destination)htmlSerializer);
                Serializer xtSurefire = null;
                if (xeSurefire != null) {
                    XsltTransformer xt = xeSurefire.load();
                    try {
                        xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.project.getBasedir().toURI().toURL().toExternalForm()));
                        xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.surefireReportDir.toURI().toURL().toExternalForm()));
                        xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                        xt.setDestination((Destination)this.PROCESSOR.newSerializer((OutputStream)new NullOutputStream()));
                        xtSurefire = xt;
                    }
                    catch (Exception ex) {
                        this.getLog().warn((CharSequence)"Unable to generate surefire report", (Throwable)ex);
                    }
                } else {
                    xtSurefire = this.PROCESSOR.newSerializer((OutputStream)new NullOutputStream());
                }
                ProcessedFile pf = new ProcessedFile(this.testDir, xspec, this.reportDir, xspecHtmlResult);
                this.processedFiles.add(pf);
                processedFileAdded = true;
                String relativeCssPath = (pf.getRelativeCssPath().length() > 0 ? pf.getRelativeCssPath() + "/" : "") + RESOURCES_TEST_REPORT_CSS;
                reporter.setParameter(new QName("report-css-uri"), (XdmValue)new XdmAtomicValue(relativeCssPath));
                TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)reporter);
                xtXSpec.setDestination((Destination)destination);
                xtXSpec.setBaseOutputURI(xspecXmlResult.toURI().toString());
                StreamSource xspecSource = new StreamSource(xspec);
                xtXSpec.setSource((Source)xspecSource);
                xtXSpec.setURIResolver(uriResolver);
                xtXSpec.transform();
            }
            catch (SaxonApiException te) {
                this.getLog().error((CharSequence)te.getMessage());
                this.getLog().debug((Throwable)te);
                if (processedFileAdded) break block9;
                ProcessedFile pf = new ProcessedFile(this.testDir, xspec, this.reportDir, this.getXSpecHtmlResultPath(this.getReportDir(), xspec));
                this.processedFiles.add(pf);
                processedFileAdded = true;
            }
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", xspec.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (this.processedFiles.size() > 0) {
            this.processedFiles.get(this.processedFiles.size() - 1).setResults(resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        }
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompiledXSpec compileXSpec(XsltExecutable executable, File xspec) {
        XsltTransformer compiler = executable.load();
        InputStream isXSpec = null;
        try {
            File compiledXSpec = this.getCompiledXSpecPath(this.getReportDir(), xspec);
            this.getLog().info((CharSequence)("Compiling XSpec to XSLT: " + compiledXSpec));
            isXSpec = new FileInputStream(xspec);
            SAXParser parser = PARSER_FACTORY.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XSpecTestFilter xspecTestFilter = new XSpecTestFilter(reader, xspec.getAbsolutePath(), this.xsltCompiler.getURIResolver(), this, this.getLog().isDebugEnabled(), new String[0]);
            InputSource inXSpec = new InputSource(isXSpec);
            inXSpec.setSystemId(xspec.getAbsolutePath());
            compiler.setSource((Source)new SAXSource(xspecTestFilter, inXSpec));
            Serializer serializer = this.PROCESSOR.newSerializer();
            serializer.setOutputFile(compiledXSpec);
            compiler.setDestination((Destination)serializer);
            compiler.transform();
            CompiledXSpec compiledXSpec2 = new CompiledXSpec(xspecTestFilter.getTests(), xspecTestFilter.getPendingTests(), compiledXSpec);
            return compiledXSpec2;
        }
        catch (SaxonApiException sae) {
            this.getLog().error((CharSequence)sae.getMessage());
            this.getLog().debug((Throwable)sae);
        }
        catch (FileNotFoundException | ParserConfigurationException pce) {
            this.getLog().error((Throwable)pce);
        }
        catch (SAXException saxe) {
            this.getLog().error((CharSequence)saxe.getMessage());
            this.getLog().debug((Throwable)saxe);
        }
        finally {
            if (isXSpec != null) {
                try {
                    isXSpec.close();
                }
                catch (IOException ioe) {
                    this.getLog().warn((Throwable)ioe);
                }
            }
        }
        return null;
    }

    final File getCompiledXSpecPath(File xspecReportDir, File xspec) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        Path relativeSource = this.testDir.toPath().relativize(xspec.toPath());
        File executionReportDir = this.execution != null && this.execution.getExecutionId() != null && !"default".equals(this.execution.getExecutionId()) ? new File(xspecReportDir, this.execution.getExecutionId()) : xspecReportDir;
        executionReportDir.mkdirs();
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        File fCompiledDir = new File(outputDir, "xslt");
        if (!fCompiledDir.exists()) {
            fCompiledDir.mkdirs();
        }
        return new File(fCompiledDir, xspec.getName() + ".xslt");
    }

    final File getXSpecXmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "xml");
    }

    final File getXSpecHtmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "html");
    }

    final File getXSpecResultPath(File xspecReportDir, File xspec, String extension) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        Path relativeSource = this.testDir.toPath().relativize(xspec.toPath());
        this.getLog().debug((CharSequence)("executionId=" + this.execution.getExecutionId()));
        this.getLog().debug((CharSequence)("relativeSource=" + relativeSource.toString()));
        File executionReportDir = this.execution != null && this.execution.getExecutionId() != null && !"default".equals(this.execution.getExecutionId()) ? new File(xspecReportDir, this.execution.getExecutionId()) : xspecReportDir;
        executionReportDir.mkdirs();
        this.getLog().debug((CharSequence)("executionReportDir=" + executionReportDir.getAbsolutePath()));
        File outputDir = executionReportDir.toPath().resolve(relativeSource).toFile();
        this.getLog().debug((CharSequence)("outputDir=" + outputDir.getAbsolutePath()));
        return new File(outputDir, xspec.getName().replace(".xspec", "") + "." + extension);
    }

    private List<File> findAllXSpecs(File xspecTestDir) {
        ArrayList<File> specs = new ArrayList<File>();
        if (xspecTestDir.exists()) {
            File[] specFiles = xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xspec");
                }
            });
            specs.addAll(Arrays.asList(specFiles));
            for (File subDir : xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                specs.addAll(this.findAllXSpecs(subDir));
            }
        }
        return specs;
    }

    protected boolean isSkipTests() {
        return this.skipTests;
    }

    protected String getXspecCompiler() {
        return this.xspecCompiler;
    }

    protected String getXspecReporter() {
        return this.xspecReporter;
    }

    protected File getReportDir() {
        return this.reportDir;
    }

    protected File getTestDir() {
        return this.testDir;
    }

    protected List<String> getExcludes() {
        return this.excludes;
    }

    private URIResolver buildUriResolver(URIResolver saxonUriResolver) throws DependencyResolutionRequiredException, IOException, XMLStreamException, MojoFailureException {
        String thisJar = null;
        String marker = this.createMarker();
        this.getLog().debug((CharSequence)("marker=" + marker));
        for (String s : this.getClassPathElements()) {
            if (!s.contains(marker)) continue;
            thisJar = s;
            break;
        }
        if (thisJar == null) {
            throw new MojoFailureException("Unable to locate plugin jar file from classpath-");
        }
        String jarUri = this.makeJarUri(thisJar);
        File tmpCatalog = File.createTempFile("tmp", "-catalog.xml");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpCatalog), Charset.forName("UTF-8"));){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(osw);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("catalog");
            xmlWriter.setDefaultNamespace(CATALOG_NS);
            xmlWriter.writeNamespace("", CATALOG_NS);
            xmlWriter.writeStartElement("rewriteURI");
            xmlWriter.writeAttribute("uriStartString", XSPEC_PREFIX);
            xmlWriter.writeAttribute("rewritePrefix", jarUri);
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("rewriteSystem");
            xmlWriter.writeAttribute("uriStartString", XSPEC_PREFIX);
            xmlWriter.writeAttribute("rewritePrefix", jarUri);
            xmlWriter.writeEndElement();
            if (this.catalogFile != null) {
                xmlWriter.writeStartElement("nextCatalog");
                xmlWriter.writeAttribute("catalog", this.catalogFile.toURI().toURL().toExternalForm());
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            osw.flush();
        }
        if (!this.keepGeneratedCatalog.booleanValue()) {
            tmpCatalog.deleteOnExit();
        } else {
            this.getLog().info((CharSequence)("keeping generated catalog: " + tmpCatalog.toURI().toURL().toExternalForm()));
        }
        return new Resolver(saxonUriResolver, tmpCatalog, this.getLog());
    }

    private String makeJarUri(String jarFile) throws MalformedURLException {
        this.getLog().debug((CharSequence)String.format("makeJarUri(%s)", jarFile));
        return "jar:" + jarFile + "!/";
    }

    private List<String> getClassPathElements() throws MojoFailureException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            ArrayList<String> ret = new ArrayList<String>(ucl.getURLs().length);
            for (URL u : ucl.getURLs()) {
                ret.add(u.toExternalForm());
            }
            return ret;
        }
        throw new MojoFailureException("classloader is not a URL classloader : " + cl.getClass().getName());
    }

    private String createMarker() throws IOException {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream("/xspec-maven-plugin.properties"));
        return String.format("%s-%s", props.getProperty("plugin.artifactId"), props.getProperty("plugin.version"));
    }

    private static Configuration getSaxonConfiguration() {
        Configuration ret = Configuration.newConfiguration();
        ret.setConfigurationProperty("http://saxon.sf.net/feature/allow-external-functions", (Object)Boolean.TRUE);
        return ret;
    }
}

