/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;

public class ProcessedFile
implements Serializable {
    private final Path rootSourceDir;
    private final Path sourceFile;
    private final String relativeSourcePath;
    private final Path outputDir;
    private final Path reportFile;
    private final String relativeReportPath;
    private final String relativeCssPath;
    private int passed;
    private int pending;
    private int failed;
    private int missed;
    private int total;

    public ProcessedFile(File rootSourceDir, File sourceFile, File outputDir, File reportFile) {
        this.rootSourceDir = rootSourceDir.getAbsoluteFile().toPath();
        this.sourceFile = sourceFile.getAbsoluteFile().toPath();
        this.outputDir = outputDir.getAbsoluteFile().toPath();
        this.reportFile = reportFile.getAbsoluteFile().toPath();
        this.relativeSourcePath = this.rootSourceDir.relativize(this.sourceFile).toString();
        this.relativeReportPath = this.outputDir.relativize(this.reportFile).toString();
        this.relativeCssPath = this.reportFile.getParent().relativize(this.outputDir).toString();
    }

    public Path getRootSourceDir() {
        return this.rootSourceDir;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public String getRelativeSourcePath() {
        return this.relativeSourcePath;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public Path getReportFile() {
        return this.reportFile;
    }

    public String getRelativeReportPath() {
        return this.relativeReportPath;
    }

    public String getRelativeCssPath() {
        return this.relativeCssPath;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getPending() {
        return this.pending;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getMissed() {
        return this.missed;
    }

    public int getTotal() {
        return this.total;
    }

    public void setResults(int passed, int pending, int failed, int missed, int total) {
        this.passed = passed;
        this.pending = pending;
        this.failed = failed;
        this.missed = missed;
        this.total = total;
    }
}

