/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import uk.org.adamretter.maven.LogProvider;

public class XSpecResultsHandler
extends DefaultHandler2 {
    private static final String XSPEC_NS = "http://www.jenitennison.com/xslt/xspec";
    private int tests = 0;
    private int passed = 0;
    private int failed = 0;
    private int pending = 0;
    private final LogProvider logProvider;

    public XSpecResultsHandler(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (uri != null && uri.equals(XSPEC_NS) && localName.equals("test")) {
            ++this.tests;
            String successful = attributes.getValue("successful");
            String sPending = attributes.getValue("pending");
            if (successful != null && successful.equals("true")) {
                ++this.passed;
            } else if (sPending != null && sPending.length() > 0) {
                ++this.pending;
            } else {
                ++this.failed;
            }
        }
    }

    public int getTests() {
        return this.tests;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getPending() {
        return this.pending;
    }
}

