/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.trans.XPathException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import uk.org.adamretter.maven.LogProvider;
import uk.org.adamretter.maven.ResourceResolver;

public class XSpecURIResolver
extends StandardURIResolver {
    private final ResourceResolver resourceResolver;
    private final LogProvider logProvider;
    private final URIResolver catalogResolver;

    public XSpecURIResolver(LogProvider logProvider, ResourceResolver resourceResolver, File catalogFile) {
        this.logProvider = logProvider;
        this.resourceResolver = resourceResolver;
        if (resourceResolver == null) {
            System.err.println("resourceResolver is null !!!");
        }
        CatalogResolver tmpCatalogResolver = null;
        if (catalogFile != null && catalogFile.exists()) {
            CatalogManager cm = new CatalogManager();
            CatalogResolver cr = new CatalogResolver(cm);
            try {
                cr.getCatalog().parseCatalog(catalogFile.toURI().toURL());
                tmpCatalogResolver = cr;
            }
            catch (IOException ex) {
                this.getLogProvider().getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
            }
        }
        this.catalogResolver = tmpCatalogResolver;
    }

    public Source resolve(String href, String base) throws XPathException {
        this.getLogProvider().getLog().debug((CharSequence)String.format("resolve(%s,%s)", href, base));
        Source saxonSource = super.resolve(href, base);
        if (saxonSource != null && new File(saxonSource.getSystemId()).exists()) {
            this.getLogProvider().getLog().debug((CharSequence)String.format("Saxon Resolved URI href=%s ,base=%s to %s", href, base, saxonSource));
            return saxonSource;
        }
        this.getLogProvider().getLog().debug((CharSequence)String.format("Saxon failed URIResolution for: %s", saxonSource.getSystemId()));
        String path = URI.create(saxonSource.getSystemId()).getPath();
        this.getLogProvider().getLog().debug((CharSequence)String.format("Attempting URIResolution for XSpec from: %s", path));
        InputStream is = this.resourceResolver.getResource(path);
        if (is != null) {
            StreamSource xspecSource = new StreamSource(is);
            xspecSource.setSystemId(path);
            return xspecSource;
        }
        if (this.catalogResolver != null) {
            this.getLogProvider().getLog().debug((CharSequence)String.format("Attempting catalog resolution for %s", path));
            try {
                Source ret = this.catalogResolver.resolve(href, base);
                if (ret == null) {
                    this.getLogProvider().getLog().warn((CharSequence)String.format("Resolution failed for %s %s", href, base));
                }
                return ret;
            }
            catch (TransformerException ex) {
                this.getLogProvider().getLog().warn((CharSequence)"Could not Resolve URI for XSpec!");
                return null;
            }
        }
        this.getLogProvider().getLog().warn((CharSequence)"Could not Resolve URI for XSpec!");
        return null;
    }

    protected final LogProvider getLogProvider() {
        return this.logProvider;
    }
}

