/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.TeeDestination;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.org.adamretter.maven.CompiledXSpec;
import uk.org.adamretter.maven.LogProvider;
import uk.org.adamretter.maven.ResourceResolver;
import uk.org.adamretter.maven.XSpecResultsHandler;
import uk.org.adamretter.maven.XSpecTestFilter;
import uk.org.adamretter.maven.XSpecURIResolver;

@Mojo(name="run-xspec", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class XSpecMojo
extends AbstractMojo
implements LogProvider {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(defaultValue="/xspec/compiler/generate-xspec-tests.xsl", required=true)
    private String xspecCompiler;
    @Parameter(defaultValue="/xspec/reporter/format-xspec-report.xsl", required=true)
    private String xspecReporter;
    @Parameter(defaultValue="${basedir}/src/test/xspec", required=true)
    private File testDir;
    @Parameter(alias="excludes")
    private List<String> excludes;
    @Parameter(defaultValue="${project.build.directory}/xspec-reports", required=true)
    private File reportDir;
    @Parameter(defaultValue="${catalog.filename}")
    private File catalogFile;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports", required=true)
    private File surefireReportDir;
    @Parameter(defaultValue="false")
    private Boolean generateSurefireReport;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static final Configuration saxonConfiguration = XSpecMojo.getSaxonConfiguration();
    private static final Processor processor = new Processor(saxonConfiguration);
    private final ResourceResolver resourceResolver = new ResourceResolver(this);
    private final XsltCompiler xsltCompiler = processor.newXsltCompiler();
    private boolean uriResolverSet = false;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    private static final String RESOURCES_TEST_REPORT_CSS = "resources/test-report.css";
    static final String XSPEC_MOJO_PFX = "[xspec-mojo] ";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.uriResolverSet) {
            this.xsltCompiler.setURIResolver(this.buildUriResolver());
            this.uriResolverSet = true;
        }
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"'skipTests' is set... skipping XSpec tests!");
            return;
        }
        String compilerPath = this.getXspecCompiler();
        this.getLog().debug((CharSequence)("Using XSpec Compiler: " + compilerPath));
        String reporterPath = this.getXspecReporter();
        this.getLog().debug((CharSequence)("Using XSpec Reporter: " + reporterPath));
        InputStream isCompiler = null;
        try {
            isCompiler = this.resourceResolver.getResource(compilerPath);
            if (isCompiler == null) {
                throw new MojoExecutionException("Could not find XSpec Compiler stylesheets in: " + compilerPath);
            }
            InputStream isReporter = this.resourceResolver.getResource(reporterPath);
            if (isReporter == null) {
                throw new MojoExecutionException("Could not find XSpec Reporter stylesheets in: " + reporterPath);
            }
            StreamSource srcCompiler = new StreamSource(isCompiler);
            srcCompiler.setSystemId(compilerPath);
            XsltExecutable xeCompiler = this.xsltCompiler.compile((Source)srcCompiler);
            StreamSource srcReporter = new StreamSource(isReporter);
            srcReporter.setSystemId(reporterPath);
            XsltExecutable xeReporter = this.xsltCompiler.compile((Source)srcReporter);
            XsltTransformer xtReporter = xeReporter.load();
            xtReporter.setParameter(new QName("report-css-uri"), (XdmValue)new XdmAtomicValue(RESOURCES_TEST_REPORT_CSS));
            this.getLog().debug((CharSequence)("Looking for XSpecs in: " + this.getTestDir()));
            List<File> xspecs = this.findAllXSpecs(this.getTestDir());
            this.getLog().info((CharSequence)("Found " + xspecs.size() + " XSpecs..."));
            XsltExecutable xeSurefire = null;
            if (this.generateSurefireReport.booleanValue()) {
                XsltCompiler compiler = processor.newXsltCompiler();
                xeSurefire = compiler.compile((Source)new StreamSource(this.getClass().getResourceAsStream("/surefire-reporter.xsl")));
            }
            boolean failed = false;
            for (File xspec : xspecs) {
                if (this.shouldExclude(xspec)) {
                    this.getLog().warn((CharSequence)("Skipping excluded XSpec: " + xspec.getAbsolutePath()));
                    continue;
                }
                if (this.processXSpec(xspec, xeCompiler, xtReporter, xeSurefire)) continue;
                failed = true;
            }
            File cssFile = new File(this.getReportDir(), RESOURCES_TEST_REPORT_CSS);
            cssFile.getParentFile().mkdirs();
            BufferedInputStream is = new BufferedInputStream(this.resourceResolver.getResource("/xspec/reporter/test-report.css"));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cssFile));
                byte[] buffer = new byte[1024];
                int read = is.read(buffer);
                while (read > 0) {
                    bos.write(buffer, 0, read);
                    read = is.read(buffer);
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"while extracting CSS: ", (Throwable)ex);
            }
            if (failed) {
                throw new MojoFailureException("Some XSpec tests failed or were missed!");
            }
        }
        catch (SaxonApiException sae) {
            this.getLog().error((CharSequence)("Unable to compile the XSpec Compiler: " + compilerPath));
            throw new MojoExecutionException(sae.getMessage(), (Exception)((Object)sae));
        }
        finally {
            if (isCompiler != null) {
                try {
                    isCompiler.close();
                }
                catch (IOException ioe) {
                    this.getLog().warn((Throwable)ioe);
                }
            }
        }
    }

    private boolean shouldExclude(File xspec) {
        List<String> excludePatterns = this.getExcludes();
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                if (!xspec.getAbsolutePath().endsWith(excludePattern)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean processXSpec(File xspec, XsltExecutable executable, XsltTransformer reporter, XsltExecutable xeSurefire) {
        this.getLog().info((CharSequence)("Processing XSpec: " + xspec.getAbsolutePath()));
        CompiledXSpec compiledXSpec = this.compileXSpec(executable, xspec);
        if (compiledXSpec == null) {
            return false;
        }
        XSpecResultsHandler resultsHandler = new XSpecResultsHandler(this);
        try {
            XsltExecutable xeXSpec = this.xsltCompiler.compile((Source)new StreamSource(compiledXSpec.getCompiledStylesheet()));
            XsltTransformer xtXSpec = xeXSpec.load();
            xtXSpec.setInitialTemplate(QName.fromClarkName((String)"{http://www.jenitennison.com/xslt/xspec}main"));
            this.getLog().info((CharSequence)("Executing XSpec: " + compiledXSpec.getCompiledStylesheet().getName()));
            File xspecXmlResult = this.getXSpecXmlResultPath(this.getReportDir(), xspec);
            Serializer xmlSerializer = processor.newSerializer();
            xmlSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            xmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            xmlSerializer.setOutputFile(xspecXmlResult);
            File xspecHtmlResult = this.getXSpecHtmlResultPath(this.getReportDir(), xspec);
            Serializer htmlSerializer = processor.newSerializer();
            htmlSerializer.setOutputProperty(Serializer.Property.METHOD, "html");
            htmlSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            htmlSerializer.setOutputFile(xspecHtmlResult);
            reporter.setDestination((Destination)htmlSerializer);
            Serializer xtSurefire = null;
            if (xeSurefire != null) {
                XsltTransformer xt = xeSurefire.load();
                try {
                    xt.setParameter(new QName("baseDir"), (XdmValue)new XdmAtomicValue(this.project.getBasedir().toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("outputDir"), (XdmValue)new XdmAtomicValue(this.surefireReportDir.toURI().toURL().toExternalForm()));
                    xt.setParameter(new QName("reportFileName"), (XdmValue)new XdmAtomicValue(xspecXmlResult.getName()));
                    xt.setDestination((Destination)processor.newSerializer((OutputStream)new NullOutputStream()));
                    xtSurefire = xt;
                }
                catch (Exception exception) {}
            } else {
                xtSurefire = processor.newSerializer((OutputStream)new NullOutputStream());
            }
            TeeDestination destination = new TeeDestination((Destination)new TeeDestination((Destination)new SAXDestination((ContentHandler)resultsHandler), (Destination)new TeeDestination((Destination)xmlSerializer, (Destination)xtSurefire)), (Destination)reporter);
            xtXSpec.setDestination((Destination)destination);
            StreamSource xspecSource = new StreamSource(xspec);
            xtXSpec.setSource((Source)xspecSource);
            xtXSpec.transform();
        }
        catch (SaxonApiException te) {
            this.getLog().error((CharSequence)te.getMessage());
            this.getLog().debug((Throwable)te);
        }
        int missed = compiledXSpec.getTests() - resultsHandler.getTests();
        String msg = String.format("%s results [Passed/Pending/Failed/Missed/Total] = [%d/%d/%d/%d/%d]", xspec.getName(), resultsHandler.getPassed(), resultsHandler.getPending(), resultsHandler.getFailed(), missed, compiledXSpec.getTests());
        if (resultsHandler.getFailed() + missed > 0) {
            this.getLog().error((CharSequence)msg);
            return false;
        }
        this.getLog().info((CharSequence)msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompiledXSpec compileXSpec(XsltExecutable executable, File xspec) {
        XsltTransformer compiler = executable.load();
        InputStream isXSpec = null;
        try {
            File compiledXSpec = this.getCompiledXSpecPath(this.getReportDir(), xspec);
            this.getLog().info((CharSequence)("Compiling XSpec to XSLT: " + compiledXSpec));
            isXSpec = new FileInputStream(xspec);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XSpecTestFilter xspecTestFilter = new XSpecTestFilter(reader);
            InputSource inXSpec = new InputSource(isXSpec);
            inXSpec.setSystemId(xspec.getAbsolutePath());
            compiler.setSource((Source)new SAXSource(xspecTestFilter, inXSpec));
            Serializer serializer = processor.newSerializer();
            serializer.setOutputFile(compiledXSpec);
            compiler.setDestination((Destination)serializer);
            compiler.transform();
            CompiledXSpec compiledXSpec2 = new CompiledXSpec(xspecTestFilter.getTests(), xspecTestFilter.getPendingTests(), compiledXSpec);
            return compiledXSpec2;
        }
        catch (SaxonApiException sae) {
            this.getLog().error((CharSequence)sae.getMessage());
            this.getLog().debug((Throwable)sae);
        }
        catch (FileNotFoundException | ParserConfigurationException pce) {
            this.getLog().error((Throwable)pce);
        }
        catch (SAXException saxe) {
            this.getLog().error((CharSequence)saxe.getMessage());
            this.getLog().debug((Throwable)saxe);
        }
        finally {
            if (isXSpec != null) {
                try {
                    isXSpec.close();
                }
                catch (IOException ioe) {
                    this.getLog().warn((Throwable)ioe);
                }
            }
        }
        return null;
    }

    final File getCompiledXSpecPath(File xspecReportDir, File xspec) {
        File fCompiledDir = new File(xspecReportDir, "xslt");
        if (!fCompiledDir.exists()) {
            fCompiledDir.mkdirs();
        }
        return new File(fCompiledDir, xspec.getName() + ".xslt");
    }

    final File getXSpecXmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "xml");
    }

    final File getXSpecHtmlResultPath(File xspecReportDir, File xspec) {
        return this.getXSpecResultPath(xspecReportDir, xspec, "html");
    }

    final File getXSpecResultPath(File xspecReportDir, File xspec, String extension) {
        if (!xspecReportDir.exists()) {
            xspecReportDir.mkdirs();
        }
        return new File(xspecReportDir, xspec.getName().replace(".xspec", "") + "." + extension);
    }

    private List<File> findAllXSpecs(File xspecTestDir) {
        ArrayList<File> specs = new ArrayList<File>();
        if (xspecTestDir.exists()) {
            File[] specFiles = xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xspec");
                }
            });
            specs.addAll(Arrays.asList(specFiles));
            for (File subDir : xspecTestDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                specs.addAll(this.findAllXSpecs(subDir));
            }
        }
        return specs;
    }

    protected boolean isSkipTests() {
        return this.skipTests;
    }

    protected String getXspecCompiler() {
        return this.xspecCompiler;
    }

    protected String getXspecReporter() {
        return this.xspecReporter;
    }

    protected File getReportDir() {
        return this.reportDir;
    }

    protected File getTestDir() {
        return this.testDir;
    }

    protected List<String> getExcludes() {
        return this.excludes;
    }

    private URIResolver buildUriResolver() {
        return new XSpecURIResolver(this, this.resourceResolver, this.catalogFile);
    }

    private static Configuration getSaxonConfiguration() {
        Configuration ret = null;
        ret = Configuration.newConfiguration();
        ret.setConfigurationProperty("http://saxon.sf.net/feature/allow-external-functions", (Object)Boolean.TRUE);
        return ret;
    }
}

