/*
 * Decompiled with CFR 0.152.
 */
package uk.org.adamretter.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import uk.org.adamretter.maven.LogProvider;

public class ResourceResolver {
    private final LogProvider logProvider;

    public ResourceResolver(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public InputStream getResource(String path) {
        this.getLogProvider().getLog().debug((CharSequence)("Attempting to resolve resource: " + path));
        if (path == null) {
            return null;
        }
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is != null) {
            this.getLogProvider().getLog().debug((CharSequence)("Found resource from classpath: " + path));
            return is;
        }
        this.getLogProvider().getLog().debug((CharSequence)("Could not find resource from classpath: " + path));
        File f = new File(path);
        try {
            if (f.exists()) {
                this.getLogProvider().getLog().debug((CharSequence)("Found resource from filesystem: " + f.getAbsolutePath()));
                return new FileInputStream(f);
            }
            this.getLogProvider().getLog().debug((CharSequence)("Could not find resource from filesystem: " + f.getAbsolutePath()));
        }
        catch (FileNotFoundException fnfe) {
            this.getLogProvider().getLog().debug((CharSequence)("Could not find resource from filesystem: " + f.getAbsolutePath()), (Throwable)fnfe);
        }
        return null;
    }

    protected LogProvider getLogProvider() {
        return this.logProvider;
    }
}

