/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wizzie.bootstrapper.builder.Config;
import io.wizzie.normalizer.exceptions.MaxOutputKafkaTopics;
import io.wizzie.normalizer.exceptions.PlanBuilderException;
import io.wizzie.normalizer.model.FunctionModel;
import io.wizzie.normalizer.model.SinkModel;
import io.wizzie.normalizer.model.StreamModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class PlanModel {
    private Map<String, List<String>> inputs;
    private Map<String, StreamModel> streams;
    private List<String> definedStreams = new ArrayList<String>();

    @JsonCreator
    public PlanModel(@JsonProperty(value="inputs") Map<String, List<String>> inputs, @JsonProperty(value="streams") Map<String, StreamModel> streams) {
        this.inputs = inputs;
        this.streams = streams;
    }

    @JsonProperty
    public Map<String, List<String>> getInputs() {
        return this.inputs;
    }

    @JsonProperty
    public Map<String, StreamModel> getStreams() {
        return this.streams;
    }

    public List<String> getDefinedStreams() {
        return this.definedStreams;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("inputs: ").append(this.inputs).append(", ").append("streams: ").append(this.streams).append("}");
        return builder.toString();
    }

    public String printExecutionPlan() {
        ObjectMapper mapper = new ObjectMapper();
        StringBuilder builder = new StringBuilder();
        StringBuilder propertiesBuilder = new StringBuilder();
        propertiesBuilder.append("\n").append("Properties: ").append("\n");
        this.inputs.entrySet().forEach(inputEntry -> {
            builder.append("\n");
            builder.append("CREATE STREAMS ").append(inputEntry.getValue()).append(" FROM KAFKA ").append((String)inputEntry.getKey());
        });
        builder.append("\n");
        this.streams.entrySet().forEach(entry -> {
            builder.append("\n");
            builder.append("FROM ").append((String)entry.getKey()).append("\n");
            List<FunctionModel> funcs = ((StreamModel)entry.getValue()).getFuncs();
            if (funcs != null) {
                List funcNames = funcs.stream().map(FunctionModel::getName).collect(Collectors.toList());
                builder.append("   TRANSFORM USING ").append(funcNames).append("\n");
                funcs.forEach(func -> {
                    propertiesBuilder.append("   * ").append(func.getName()).append(": ");
                    try {
                        propertiesBuilder.append(mapper.writeValueAsString(func.getProperties())).append("\n");
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                });
            }
            List<SinkModel> kafkaTopics = ((StreamModel)entry.getValue()).getSinks().stream().filter(sink -> sink.getType().equals("kafka")).collect(Collectors.toList());
            List<SinkModel> streamNames = ((StreamModel)entry.getValue()).getSinks().stream().filter(sink -> sink.getType().equals("stream")).collect(Collectors.toList());
            kafkaTopics.forEach(sink -> {
                builder.append("   SEND TO KAFKA ").append(sink.getTopic()).append(" PARTITION BY ").append(sink.getPartitionBy());
                if (sink.getFilter() != null) {
                    builder.append(" FILTER WITH ").append(sink.getFilter().getName());
                    propertiesBuilder.append("   * ").append(sink.getFilter().getName()).append(": ");
                    try {
                        propertiesBuilder.append(mapper.writeValueAsString(sink.getFilter().getProperties())).append("\n");
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
                builder.append("\n");
            });
            streamNames.forEach(sink -> {
                builder.append("   SEND TO STREAM ").append(sink.getTopic()).append(" PARTITION BY ").append(sink.getPartitionBy());
                if (sink.getFilter() != null) {
                    builder.append(" FILTER WITH ").append(sink.getFilter().getName());
                    propertiesBuilder.append("   * ").append(sink.getFilter().getName()).append(": ");
                    try {
                        propertiesBuilder.append(mapper.writeValueAsString(sink.getFilter().getProperties())).append("\n");
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
                builder.append("\n");
            });
        });
        builder.append(propertiesBuilder.toString());
        return builder.toString();
    }

    public void validate(Config config) throws PlanBuilderException {
        this.validateInputs();
        this.validateStreams();
        this.validateKafkaOutputs(config);
    }

    private void validateInputs() throws PlanBuilderException {
        for (List<String> streams : this.inputs.values()) {
            for (String stream : streams) {
                if (this.definedStreams.contains(stream)) {
                    this.definedStreams.clear();
                    throw new PlanBuilderException(String.format("Stream[%s]: Duplicated", stream));
                }
                this.definedStreams.add(stream);
            }
        }
    }

    private void validateStreams() throws PlanBuilderException {
        for (Map.Entry<String, StreamModel> entry : this.streams.entrySet()) {
            List<SinkModel> sinks = entry.getValue().getSinks();
            if (sinks == null) continue;
            for (SinkModel sink : sinks) {
                if (!sink.getType().equals("stream")) continue;
                this.definedStreams.add(sink.getTopic());
            }
            if (this.definedStreams.contains(entry.getKey())) continue;
            throw new PlanBuilderException(String.format("Stream[%s]: Not defined on inputs. Available definedStreams %s", entry.getKey(), this.definedStreams));
        }
    }

    private void validateKafkaOutputs(Config config) throws MaxOutputKafkaTopics {
        this.streams.forEach((name, stream) -> stream.getSinks().forEach(SinkModel::getType));
        Optional<List> types = this.streams.entrySet().stream().map(entry -> ((StreamModel)entry.getValue()).getSinks()).map(sinks -> sinks.stream().map(SinkModel::getType).collect(Collectors.toList())).reduce((sinks1, sinks2) -> {
            sinks1.addAll(sinks2);
            return sinks1;
        });
        if (types.isPresent()) {
            Long kafkaOutputs = types.get().stream().filter(type -> type.equals("kafka")).count();
            Integer maxKafkaOutputs = (Integer)config.getOrDefault("max.kafka.output.topics", (Object)Integer.MAX_VALUE);
            if (kafkaOutputs > (long)maxKafkaOutputs.intValue()) {
                throw new MaxOutputKafkaTopics(String.format("You try to create [%s] topics, and the limit is [%s]", kafkaOutputs, maxKafkaOutputs));
            }
        }
    }
}

