/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.base.utils;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConvertFrom {
    NUMBER{

        @Override
        public Number toNumber(Object value) {
            if (this.check(value).booleanValue()) {
                return (Number)value;
            }
            log.debug("Value '" + value + "' is not Number type!");
            return null;
        }

        @Override
        public String toString(Object value) {
            if (this.check(value).booleanValue()) {
                return String.valueOf(value);
            }
            log.debug("Value '" + value + "' is not Number type!");
            return null;
        }

        @Override
        public Boolean toBoolean(Object value) {
            if (this.check(value).booleanValue()) {
                return ((Number)value).longValue() > 0L;
            }
            log.debug("Value '" + value + "' is not Number type!");
            return null;
        }

        Boolean check(Object value) {
            return value instanceof Number;
        }
    }
    ,
    STRING{

        @Override
        public Number toNumber(Object value) throws ParseException {
            if (this.check(value).booleanValue()) {
                return NumberFormat.getInstance(Locale.US).parse((String)value);
            }
            log.debug("Value '" + value + "' is not String type!");
            return null;
        }

        @Override
        public String toString(Object value) {
            if (this.check(value).booleanValue()) {
                return (String)value;
            }
            log.debug("Value '" + value + "' is not String type!");
            return null;
        }

        @Override
        public Boolean toBoolean(Object value) {
            if (this.check(value).booleanValue()) {
                return Boolean.valueOf((String)value);
            }
            log.debug("Value '" + value + "' is not String type!");
            return null;
        }

        Boolean check(Object value) {
            return value instanceof String;
        }
    }
    ,
    BOOLEAN{

        @Override
        public Number toNumber(Object value) throws ParseException {
            if (this.check(value).booleanValue()) {
                return (Boolean)value != false ? 1 : 0;
            }
            log.debug("Value '" + value + "' is not Boolean type!");
            return null;
        }

        @Override
        public String toString(Object value) {
            if (this.check(value).booleanValue()) {
                return (Boolean)value != false ? "true" : "false";
            }
            log.debug("Value '" + value + "' is not Boolean type!");
            return null;
        }

        @Override
        public Boolean toBoolean(Object value) {
            if (this.check(value).booleanValue()) {
                return (Boolean)value;
            }
            log.debug("Value '" + value + "' is not Boolean type!");
            return null;
        }

        Boolean check(Object value) {
            return value instanceof Boolean;
        }
    };

    private static final Logger log;

    public Number toNumber(Object value) throws ParseException {
        throw new AbstractMethodError();
    }

    public String toString(Object value) {
        throw new AbstractMethodError();
    }

    public Boolean toBoolean(Object value) {
        throw new AbstractMethodError();
    }

    static {
        log = LoggerFactory.getLogger(ConvertFrom.class);
    }
}

