/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.base.utils.ConversionUtils;
import io.wizzie.normalizer.exceptions.FunctionException;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.streams.KeyValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMapper
extends MapperFunction {
    public static final String FROM_FORMAT = "fromFormat";
    public static final String DIMENSION = "dimension";
    public static final String TO_FORMAT = "toFormat";
    public static final String FORCE_STRING_OUTPUT = "forceStringOutput";
    public static final String FORCE_TIMESTAMP = "forceTimestamp";
    private final String ERROR_MESSAGE_PATTERN = "%s cannot be null";
    private static final Logger log = LoggerFactory.getLogger(TimeMapper.class);
    String dimensionToProcess;
    String fromFormat;
    String toFormat;
    DateTimeFormatter fmtISO;
    Function<Object, Object> convertTime;
    boolean forceOutputString;
    boolean forceTimestamp;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimensionToProcess = (String)Preconditions.checkNotNull((Object)((String)properties.getOrDefault(DIMENSION, "")), (Object)String.format("%s cannot be null", DIMENSION));
        this.fromFormat = (String)Preconditions.checkNotNull((Object)((String)properties.getOrDefault(FROM_FORMAT, "")), (Object)String.format("%s cannot be null", FROM_FORMAT));
        this.toFormat = (String)Preconditions.checkNotNull((Object)((String)properties.getOrDefault(TO_FORMAT, "")), (Object)String.format("%s cannot be null", TO_FORMAT));
        this.forceOutputString = (Boolean)Preconditions.checkNotNull((Object)new Boolean((String)properties.getOrDefault(FORCE_STRING_OUTPUT, "false")), (Object)String.format("%s cannot be null", FORCE_STRING_OUTPUT));
        this.forceTimestamp = (Boolean)Preconditions.checkNotNull((Object)new Boolean((String)properties.getOrDefault(FORCE_TIMESTAMP, "true")), (Object)String.format("%s cannot be null", FORCE_TIMESTAMP));
        if (!(this.fromFormat.equals("ISO") || this.fromFormat.equals("millis") || this.fromFormat.equals("secs") || this.fromFormat.startsWith("pattern:"))) {
            throw new FunctionException("fromFormat at TimeMapper must be 'ISO', 'millis', 'secs' or start with 'pattern:'");
        }
        if (!(this.toFormat.equals("ISO") || this.toFormat.equals("millis") || this.toFormat.equals("secs") || this.toFormat.startsWith("pattern:"))) {
            throw new FunctionException("fromFormat at TimeMapper must be 'ISO', 'millis', 'secs' or start with 'pattern:'");
        }
        DateTimeZone zoneUTC = DateTimeZone.UTC;
        DateTimeZone.setDefault((DateTimeZone)zoneUTC);
        if (this.fromFormat.equals("ISO") || this.toFormat.equals("ISO")) {
            this.fmtISO = ISODateTimeFormat.dateTime();
        }
        if (this.toFormat.equals("secs") && this.fromFormat.equals("millis")) {
            this.convertTime = k -> {
                Long timestamp = k == null ? Long.valueOf(System.currentTimeMillis()) : ConversionUtils.toLong((Object)k);
                try {
                    timestamp = timestamp / 1000L;
                }
                catch (NullPointerException e) {
                    log.debug(e.getMessage());
                    timestamp = null;
                }
                return timestamp;
            };
        } else if (this.toFormat.equals("millis") && this.fromFormat.equals("secs")) {
            this.convertTime = k -> {
                Long timestamp;
                if (k == null) {
                    timestamp = System.currentTimeMillis();
                } else {
                    try {
                        timestamp = ConversionUtils.toLong((Object)k) * 1000L;
                    }
                    catch (NullPointerException e) {
                        log.debug(e.getMessage());
                        timestamp = null;
                    }
                }
                return timestamp;
            };
        } else if (this.toFormat.equals("ISO") && this.fromFormat.equals("secs")) {
            this.convertTime = k -> {
                Long timestamp = null;
                String time = null;
                if (k == null) {
                    timestamp = System.currentTimeMillis();
                } else {
                    try {
                        timestamp = ConversionUtils.toLong((Object)k) * 1000L;
                    }
                    catch (NullPointerException e) {
                        log.debug(e.getMessage());
                    }
                }
                DateTime dt = new DateTime((Object)timestamp);
                time = dt.toDateTimeISO().toString();
                return time;
            };
        } else if (this.toFormat.equals("ISO") && this.fromFormat.equals("millis")) {
            this.convertTime = k -> {
                Long timestamp = null;
                if (k == null) {
                    timestamp = System.currentTimeMillis();
                } else {
                    try {
                        timestamp = ConversionUtils.toLong((Object)k);
                    }
                    catch (NullPointerException e) {
                        log.debug(e.getMessage());
                    }
                }
                DateTime dt = new DateTime((Object)timestamp);
                return dt.toDateTimeISO().toString();
            };
        } else if (this.toFormat.equals("millis") && this.fromFormat.equals("ISO")) {
            this.convertTime = k -> {
                if (k != null) {
                    DateTime dt = new DateTime(k);
                    return this.fmtISO.parseMillis(dt.toDateTimeISO().toString());
                }
                return System.currentTimeMillis();
            };
        } else if (this.toFormat.equals("secs") && this.fromFormat.equals("ISO")) {
            this.convertTime = k -> {
                if (k != null) {
                    DateTime dt = new DateTime(k);
                    return this.fmtISO.parseMillis(dt.toDateTimeISO().toString()) / 1000L;
                }
                return System.currentTimeMillis() / 1000L;
            };
        } else if (this.toFormat.startsWith("pattern:") && this.fromFormat.equals("ISO")) {
            this.toFormat = this.toFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                Object timestamp = k;
                if (k == null) {
                    timestamp = System.currentTimeMillis();
                }
                DateTime dt = new DateTime(timestamp);
                DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.toFormat);
                return fmtPattern.print((ReadableInstant)dt);
            };
        } else if (this.toFormat.startsWith("pattern:") && this.fromFormat.equals("millis")) {
            this.toFormat = this.toFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                Long timestamp = k == null ? Long.valueOf(System.currentTimeMillis()) : ConversionUtils.toLong((Object)k);
                DateTime dt = new DateTime((Object)timestamp);
                DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.toFormat);
                return fmtPattern.print((ReadableInstant)dt);
            };
        } else if (this.toFormat.startsWith("pattern:") && this.fromFormat.equals("secs")) {
            this.toFormat = this.toFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                Long timestamp = k == null ? Long.valueOf(System.currentTimeMillis()) : Long.valueOf(ConversionUtils.toLong((Object)k) * 1000L);
                DateTime dt = new DateTime((Object)timestamp);
                DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.toFormat);
                return fmtPattern.print((ReadableInstant)dt);
            };
        } else if (this.toFormat.startsWith("pattern:") && this.fromFormat.startsWith("pattern:")) {
            this.toFormat = this.toFormat.split("pattern:")[1].trim();
            this.fromFormat = this.fromFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                DateTimeFormatter fmtToPattern = DateTimeFormat.forPattern((String)this.toFormat);
                if (k != null) {
                    DateTimeFormatter fmtFromPattern = DateTimeFormat.forPattern((String)this.fromFormat);
                    DateTime dt = fmtFromPattern.parseDateTime(k.toString());
                    return fmtToPattern.print((ReadableInstant)dt);
                }
                DateTime dt = new DateTime(System.currentTimeMillis());
                return fmtToPattern.print((ReadableInstant)dt);
            };
        } else if (this.toFormat.equals("millis") && this.fromFormat.startsWith("pattern:")) {
            this.fromFormat = this.fromFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                if (k != null) {
                    DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.fromFormat);
                    DateTime dt = fmtPattern.parseDateTime(k.toString());
                    return dt.toInstant().getMillis();
                }
                return System.currentTimeMillis();
            };
        } else if (this.toFormat.equals("secs") && this.fromFormat.startsWith("pattern:")) {
            this.fromFormat = this.fromFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                if (k != null) {
                    DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.fromFormat);
                    DateTime dt = fmtPattern.parseDateTime(k.toString());
                    return dt.toInstant().getMillis() / 1000L;
                }
                return System.currentTimeMillis() / 1000L;
            };
        } else if (this.toFormat.equals("ISO") && this.fromFormat.startsWith("pattern:")) {
            this.fromFormat = this.fromFormat.split("pattern:")[1].trim();
            this.convertTime = k -> {
                if (k != null) {
                    DateTimeFormatter fmtPattern = DateTimeFormat.forPattern((String)this.fromFormat);
                    DateTime dt = fmtPattern.parseDateTime(k.toString());
                    return dt.toDateTimeISO().toString();
                }
                DateTime dt = new DateTime(System.currentTimeMillis());
                return dt.toDateTimeISO().toString();
            };
        }
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null) {
            HashMap<String, Object> newEvent = new HashMap<String, Object>();
            newEvent.putAll(value);
            if (newEvent.get(this.dimensionToProcess) == null && this.forceTimestamp || newEvent.get(this.dimensionToProcess) != null) {
                if (this.forceOutputString) {
                    newEvent.put(this.dimensionToProcess, this.convertTime.apply(newEvent.get(this.dimensionToProcess)).toString());
                } else {
                    newEvent.put(this.dimensionToProcess, this.convertTime.apply(newEvent.get(this.dimensionToProcess)));
                }
            }
            return new KeyValue((Object)key, newEvent);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }
}

