/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleArrayMapper
extends MapperFunction {
    private static final Logger log = LoggerFactory.getLogger(SimpleArrayMapper.class);
    String dimension;
    Map<String, Integer> dimensionToIndex;
    boolean deleteDimension = true;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimension = (String)Preconditions.checkNotNull((Object)((String)properties.get("dimension")), (Object)"dimension cannot be null");
        this.dimensionToIndex = (Map)Preconditions.checkNotNull((Object)((Map)properties.get("dimensionToIndex")), (Object)"dimensionToIndex cannot be null");
        this.deleteDimension = (Boolean)properties.getOrDefault("deleteDimension", true);
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        HashMap<String, Object> newEvent = null;
        if (value != null) {
            List array = (List)value.get(this.dimension);
            newEvent = new HashMap<String, Object>();
            newEvent.putAll(value);
            if (array != null) {
                Integer maxIndex = array.size() - 1;
                for (Map.Entry<String, Integer> entry : this.dimensionToIndex.entrySet()) {
                    Integer index = entry.getValue();
                    String newDimension = entry.getKey();
                    if (index <= maxIndex) {
                        newEvent.put(newDimension, array.get(index));
                        continue;
                    }
                    log.debug(String.format("The index [%s] isn't available index. MaxIndex [%s]. Array[%s]", index, maxIndex, array));
                }
                if (this.deleteDimension) {
                    newEvent.remove(this.dimension);
                }
            } else {
                log.debug(String.format("The array dimension [%s] is null, discard it", this.dimension));
            }
        }
        return KeyValue.pair((Object)key, newEvent);
    }

    @Override
    public void stop() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("dimension: ").append(this.dimension).append(", ").append("dimensionToIndex: ").append(this.dimensionToIndex).append(", ").append("deleteDimension: ").append(this.deleteDimension).append("}");
        return builder.toString();
    }
}

