/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.FilterFunc;
import io.wizzie.normalizer.funcs.FlatMapperFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterFlatMapper
extends FlatMapperFunction {
    private static final Logger log = LoggerFactory.getLogger(FormatterFlatMapper.class);
    List<String> commonFields;
    Map<String, FilterFunc> filters = new HashMap<String, FilterFunc>();
    List<Map<String, Object>> generators;
    Boolean passIfNotApply = false;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.commonFields = properties.getOrDefault("commonFields", new ArrayList());
        List filterMaps = properties.getOrDefault("filters", new ArrayList());
        this.passIfNotApply = (Boolean)properties.getOrDefault("passIfNotApply", false);
        for (Map filterDefinition : filterMaps) {
            String filterName = (String)filterDefinition.get("name");
            String className = (String)filterDefinition.get("className");
            try {
                Class<?> funcClass = Class.forName(className);
                FilterFunc func = (FilterFunc)funcClass.newInstance();
                func.init((Map)filterDefinition.get("properties"), metricsManager);
                this.filters.put(filterName, func);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        this.generators = properties.getOrDefault("generators", new ArrayList());
    }

    @Override
    public Iterable<KeyValue<String, Map<String, Object>>> process(String key, Map<String, Object> value) {
        ArrayList<KeyValue<String, Map<String, Object>>> toSend = new ArrayList<KeyValue<String, Map<String, Object>>>();
        if (value != null) {
            HashMap base = new HashMap();
            this.commonFields.forEach(field -> {
                if (value.containsKey(field)) {
                    base.put(field, value.get(field));
                }
            });
            Boolean someApply = false;
            for (Map<String, Object> generator : this.generators) {
                String filter = (String)generator.get("filter");
                if (!this.filters.containsKey(filter) || !((Boolean)this.filters.get(filter).process(key, value)).booleanValue()) continue;
                List definitions = (List)generator.get("definitions");
                someApply = true;
                for (Map definition : definitions) {
                    List fields = (List)definition.get("apply");
                    HashMap message = new HashMap();
                    message.putAll(base);
                    boolean isNullValue = false;
                    for (Map field2 : fields) {
                        String fieldName = (String)field2.get("field");
                        Object contentValue = null;
                        Map content = (Map)field2.get("content");
                        Type type = Type.valueOf(content.get("type").toString().toUpperCase());
                        switch (type) {
                            case CONSTANT: {
                                contentValue = content.get("value");
                                break;
                            }
                            case FIELDVALUE: {
                                contentValue = value.get(content.get("value"));
                            }
                        }
                        if (contentValue == null) {
                            log.warn("Detected null value for field [{}]", content.get("value"));
                            isNullValue = true;
                            break;
                        }
                        message.put(fieldName, contentValue);
                    }
                    if (isNullValue) continue;
                    toSend.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, message));
                }
            }
            if (this.passIfNotApply.booleanValue() && !someApply.booleanValue()) {
                toSend.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, value));
            }
        }
        return toSend;
    }

    @Override
    public void stop() {
    }

    private static enum Type {
        CONSTANT,
        FIELDVALUE;

    }
}

