/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.base.utils.ConversionUtils;
import io.wizzie.normalizer.funcs.MapperStoreFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueStore;

public class DiffCounterStoreMapper
extends MapperStoreFunction {
    List<String> counterFields;
    KeyValueStore<String, Map<String, Long>> storeCounter;
    Boolean sendIfZero;
    String timestampField;
    List<String> keys;
    Boolean firstTimeView;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.counterFields = (List)properties.get("counters");
        this.storeCounter = this.getStore("counter-store");
        this.sendIfZero = (Boolean)properties.get("sendIfZero");
        this.timestampField = String.valueOf(properties.get("timestamp"));
        this.keys = (List)properties.get("keys");
        this.firstTimeView = (Boolean)properties.get("firsttimeview");
        if (this.firstTimeView == null) {
            this.firstTimeView = true;
        }
        if (this.sendIfZero == null) {
            this.sendIfZero = true;
        }
        this.timestampField = this.timestampField != null ? this.timestampField : "timestamp";
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        String definedKey = "";
        if (value != null) {
            KeyValue returnValue;
            if (this.keys != null && !this.keys.isEmpty()) {
                definedKey = "";
                for (String keyElement : this.keys) {
                    if (keyElement.equals("__KEY")) {
                        definedKey = definedKey + key;
                        continue;
                    }
                    if (!value.containsKey(keyElement)) continue;
                    definedKey = definedKey + value.get(keyElement).toString();
                }
                if (definedKey.isEmpty()) {
                    definedKey = key;
                }
            }
            HashMap<String, Long> newCounters = new HashMap<String, Long>();
            HashMap<String, Long> newTimestamp = new HashMap<String, Long>();
            for (String counterField : this.counterFields) {
                Long counter = ConversionUtils.toLong((Object)value.remove(counterField));
                if (counter == null) continue;
                newCounters.put(counterField, counter);
            }
            Long timestampValue = ConversionUtils.toLong((Object)value.get(this.timestampField));
            if (timestampValue != null) {
                newTimestamp.put(this.timestampField, timestampValue);
            } else {
                timestampValue = System.currentTimeMillis() / 1000L;
                value.put(this.timestampField, timestampValue);
                newTimestamp.put(this.timestampField, timestampValue);
            }
            HashMap<String, Long> counters = (HashMap<String, Long>)this.storeCounter.get((Object)definedKey);
            if (counters != null) {
                for (Map.Entry entry : newCounters.entrySet()) {
                    Long diff;
                    Long lastValue = ConversionUtils.toLong(counters.get(entry.getKey()));
                    if (lastValue == null || (diff = Long.valueOf((Long)entry.getValue() - lastValue)) == 0L && !this.sendIfZero.booleanValue()) continue;
                    value.put((String)entry.getKey(), diff);
                }
                Long lastTimestamp = ConversionUtils.toLong(counters.get(this.timestampField));
                if (lastTimestamp != null) {
                    value.put("last_timestamp", lastTimestamp);
                }
                returnValue = new KeyValue((Object)key, value);
                counters.putAll(newCounters);
            } else {
                returnValue = this.firstTimeView == false ? null : new KeyValue((Object)key, value);
                counters = newCounters;
            }
            counters.putAll(newTimestamp);
            this.storeCounter.put((Object)definedKey, counters);
            return returnValue;
        }
        return new KeyValue(null, null);
    }

    @Override
    public void stop() {
        if (this.counterFields != null) {
            this.counterFields.clear();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" {").append("counters: ").append(this.counterFields).append(", ").append("sendIfZero: ").append(this.sendIfZero).append(", ").append("stores: ").append(this.storeCounter.name()).append(", ").append("timestamp: ").append(this.timestampField).append(", ").append("keys: ").append(this.keys).append(", ").append("firsttimeview: ").append(this.firstTimeView).append("} ");
        return builder.toString();
    }

    @Override
    public KeyValue<String, Map<String, Object>> window(long timestamp) {
        return null;
    }
}

