/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.FlatMapperFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KeyValue;

public class ArrayFlattenMapper
extends FlatMapperFunction {
    String flatDimension;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.flatDimension = (String)properties.get("flat_dimension");
    }

    @Override
    public Iterable<KeyValue<String, Map<String, Object>>> process(String key, Map<String, Object> value) {
        List array;
        List<Object> results = Collections.singletonList(new KeyValue((Object)key, value));
        if (value != null && this.flatDimension != null && value.containsKey(this.flatDimension) && (array = (List)value.remove(this.flatDimension)) != null) {
            results = array.stream().map(val -> {
                HashMap<String, Object> newValue = new HashMap<String, Object>();
                newValue.putAll(value);
                if (val instanceof Map) {
                    newValue.putAll((Map)val);
                } else {
                    newValue.put(this.flatDimension, val);
                }
                KeyValue kv = new KeyValue((Object)key, newValue);
                return kv;
            }).collect(Collectors.toList());
        }
        return results;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" {").append("flat_dimension: ").append(this.flatDimension).append("} ");
        return builder.toString();
    }

    @Override
    public void stop() {
    }
}

