/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.base.utils.ConversionUtils;
import io.wizzie.normalizer.funcs.Function;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapperStoreFunction
implements Function<KeyValue<String, Map<String, Object>>>,
Transformer<String, Map<String, Object>, KeyValue<String, Map<String, Object>>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> properties;
    private Map<String, KeyValueStore> stores = new HashMap<String, KeyValueStore>();
    private List<String> availableStores;
    private String appId;
    private Long windownTimeMs;
    private MetricsManager metricsManager;

    @Override
    public void init(Map<String, Object> properties, MetricsManager metricsManager) {
        this.availableStores = (List)properties.get("__STORES");
        this.appId = (String)properties.get("__APP_ID");
        this.windownTimeMs = ConversionUtils.toLong((Object)properties.get("__WINDOW_TIME_MS"));
        this.properties = properties;
        this.metricsManager = metricsManager;
    }

    public void init(ProcessorContext context) {
        if (this.windownTimeMs != null) {
            context.schedule(this.windownTimeMs.longValue(), PunctuationType.STREAM_TIME, this::window);
        }
        this.availableStores.forEach(storeName -> this.stores.put((String)storeName, (KeyValueStore)context.getStateStore(String.format("%s_%s", this.appId, storeName))));
        this.prepare(this.properties, this.metricsManager);
        this.log.info("   with {}", (Object)this.toString());
    }

    public KeyValue<String, Map<String, Object>> transform(String key, Map<String, Object> value) {
        return (KeyValue)this.process(key, value);
    }

    public void close() {
        this.stores.values().forEach(StateStore::close);
        this.stop();
    }

    public List<String> getAvailableStores() {
        return this.availableStores;
    }

    public <V> KeyValueStore<String, V> getStore(String storeName) {
        return this.stores.get(storeName);
    }

    public abstract KeyValue<String, Map<String, Object>> window(long var1);

    public KeyValue<String, Map<String, Object>> punctuate(long timestamp) {
        return null;
    }
}

