/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSplitterMapper
extends MapperFunction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    String dimension;
    String delimitier;
    List<String> fieldNames;
    boolean removeDimension;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimension = (String)Preconditions.checkNotNull((Object)((String)properties.get("dimension")), (Object)"dimension cannot be null");
        this.delimitier = (String)Preconditions.checkNotNull((Object)((String)properties.get("delimitier")), (Object)"delimitier cannot be null");
        this.fieldNames = (List)Preconditions.checkNotNull((Object)((List)properties.get("fields")), (Object)"fields cannot be null");
        this.removeDimension = (Boolean)properties.getOrDefault("delete_dimension", false);
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null && value.containsKey(this.dimension)) {
            String data = (String)(this.removeDimension ? value.remove(this.dimension) : value.get(this.dimension));
            String[] tokens = data.split(this.delimitier, this.fieldNames.size());
            for (int i = 0; i < tokens.length; ++i) {
                value.put(this.fieldNames.get(i), tokens[i].trim());
            }
        }
        return new KeyValue((Object)key, value);
    }

    @Override
    public void stop() {
    }
}

