/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;

public class ReplaceMapper
extends MapperFunction {
    List<Map<String, Object>> replacements;
    Map<String, Map<Object, Object>> replacementsMap = new HashMap<String, Map<Object, Object>>();

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.replacements = (List)Preconditions.checkNotNull((Object)((List)properties.get("replacements")), (Object)"replacements cannot be null");
        for (Map<String, Object> map : this.replacements) {
            String dimension = (String)map.get("dimension");
            List replaceValues = (List)map.get("replacements");
            HashMap valuesToReplace = new HashMap();
            for (Map replaceEntry : replaceValues) {
                valuesToReplace.put(replaceEntry.get("from"), replaceEntry.get("to"));
            }
            this.replacementsMap.put(dimension, valuesToReplace);
        }
        for (Map.Entry entry : this.replacementsMap.entrySet()) {
            Preconditions.checkNotNull(entry.getKey());
            Preconditions.checkNotNull(entry.getValue());
        }
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null) {
            for (Map.Entry<String, Map<Object, Object>> replacement : this.replacementsMap.entrySet()) {
                Object valueToReplace = value.get(replacement.getKey());
                for (Map.Entry<Object, Object> newValue : replacement.getValue().entrySet()) {
                    if ((newValue.getKey() != null || valueToReplace != null) && (newValue.getKey() == null || !newValue.getKey().equals(valueToReplace))) continue;
                    value.put(replacement.getKey(), newValue.getValue());
                }
            }
            return new KeyValue((Object)key, value);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }
}

