/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;

public class FieldMapper
extends MapperFunction {
    public static final String VALUE = "value";
    public static final String DIMENSION = "dimension";
    public static final String DIMENSIONS = "dimensions";
    public static final String OVERWRITE = "overwrite";
    private final String ERROR_MESSAGE_PATTERN = "%s cannot be null";
    List<Map<String, Object>> dimensionsToAdd;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimensionsToAdd = properties.getOrDefault(DIMENSIONS, new ArrayList());
        this.dimensionsToAdd.forEach(map -> {
            Preconditions.checkNotNull(map.get(DIMENSION), (Object)String.format("%s cannot be null", DIMENSION));
            Preconditions.checkNotNull(map.get(VALUE), (Object)String.format("%s cannot be null", VALUE));
        });
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null) {
            HashMap<String, Object> newEvent = new HashMap<String, Object>();
            newEvent.putAll(value);
            this.dimensionsToAdd.stream().forEach(m -> {
                if (newEvent.get(m.get(DIMENSION)) == null || m.getOrDefault(OVERWRITE, false).booleanValue()) {
                    newEvent.put((String)m.get(DIMENSION), m.get(VALUE));
                }
            });
            return new KeyValue((Object)key, newEvent);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }
}

