/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parsii.eval.Expression;
import parsii.eval.Parser;
import parsii.eval.Scope;
import parsii.eval.Variable;
import parsii.tokenizer.ParseException;

public class ArithmeticMapper
extends MapperFunction {
    List<Map<String, Object>> equations;
    Map<String, Variable> variableMap = new HashMap<String, Variable>();
    Map<String, Expression> equationMap = new HashMap<String, Expression>();
    Scope scope = Scope.create();
    private static final Logger log = LoggerFactory.getLogger(ArithmeticMapper.class);

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.equations = (List)Preconditions.checkNotNull((Object)properties.get("equations"), (Object)"equations cannot be null");
        for (Map<String, Object> equation : this.equations) {
            Preconditions.checkNotNull((Object)equation.get("as"), (Object)"as cannot be null");
            Preconditions.checkNotNull((Object)equation.get("equation"), (Object)"equation cannot be null");
            Preconditions.checkNotNull((Object)equation.get("dimensions"), (Object)"dimensions cannot be null");
        }
        for (Map<String, Object> equation : this.equations) {
            List dimensions = (List)equation.get("dimensions");
            for (String dimension : dimensions) {
                if (this.variableMap.containsKey(dimension)) continue;
                Variable var = this.scope.getVariable(dimension);
                this.variableMap.put(dimension, var);
            }
            try {
                Expression expr = Parser.parse((String)((String)equation.get("equation")), (Scope)this.scope);
                this.equationMap.put((String)equation.get("equation"), expr);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null) {
            for (Map<String, Object> equation : this.equations) {
                boolean everyVarExist = true;
                for (String dimension : (List)equation.get("dimensions")) {
                    Object value2Set = value.get(dimension);
                    if (value2Set != null) {
                        try {
                            Number number = (Number)value2Set;
                            this.variableMap.get(dimension).setValue(number.doubleValue());
                        }
                        catch (Exception e) {
                            everyVarExist = false;
                            log.debug(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    everyVarExist = false;
                    log.debug("Dimension: " + dimension + " doesn't exist to evaluate the arithmetic expression.");
                    break;
                }
                if (!everyVarExist) continue;
                value.put((String)equation.get("as"), this.equationMap.get(equation.get("equation").toString()).evaluate());
            }
            return new KeyValue((Object)key, value);
        }
        return new KeyValue((Object)key, null);
    }

    public List<Map<String, Object>> getEquations() {
        return this.equations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("equations: ");
        builder.append(this.equations);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void stop() {
    }
}

