/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl.debug;

import com.codahale.metrics.Meter;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesMeanRateMapper
extends MapperFunction {
    Logger log = LoggerFactory.getLogger(MessagesMeanRateMapper.class);
    Meter messages;
    int forEach;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.messages = new Meter();
        this.forEach = (Integer)properties.getOrDefault("foreach", 100000);
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        this.messages.mark();
        if (this.messages.getCount() % (long)this.forEach == 0L) {
            this.log.info(String.format("Messages rate mean: %.2f (Total: %d)", this.messages.getMeanRate(), this.messages.getCount()));
        }
        return new KeyValue((Object)key, value);
    }

    @Override
    public void stop() {
    }
}

