/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;

public class StringReplaceMapper
extends MapperFunction {
    String dimension;
    String targetString;
    String replacementString;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimension = (String)Preconditions.checkNotNull((Object)properties.get("dimension"), (Object)"dimension cannot be null");
        this.targetString = (String)Preconditions.checkNotNull((Object)properties.get("target_string"), (Object)"target_string cannot be null");
        this.replacementString = (String)Preconditions.checkNotNull((Object)properties.get("replacement_string"), (Object)"replacement_string cannot be null");
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        String content;
        if (value != null && (content = (String)value.get(this.dimension)) != null) {
            value.put(this.dimension, content.replaceAll(this.targetString, this.replacementString));
        }
        return new KeyValue((Object)key, value);
    }

    @Override
    public void stop() {
    }
}

