/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.FlatMapperFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitterFlatMapper
extends FlatMapperFunction {
    private static final Logger log = LoggerFactory.getLogger(SplitterFlatMapper.class);
    SplitterModel splitter;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.splitter = new SplitterModel((List)properties.get("dimensions"), (String)properties.get("timestampDim"), (String)properties.get("firstTimestampDim"), "60");
    }

    @Override
    public Iterable<KeyValue<String, Map<String, Object>>> process(String key, Map<String, Object> value) {
        if (value != null) {
            ArrayList<KeyValue<String, Map<String, Object>>> generatedPackets = new ArrayList<KeyValue<String, Map<String, Object>>>();
            if (value.containsKey(this.splitter.getFirstTimestampDim()) && value.containsKey(this.splitter.getTimestampDim())) {
                DateTime packet_start = new DateTime(Long.parseLong(value.get(this.splitter.getFirstTimestampDim()).toString()) * 1000L, DateTimeZone.UTC);
                DateTime packet_end = new DateTime(Long.parseLong(value.get(this.splitter.getTimestampDim()).toString()) * 1000L, DateTimeZone.UTC);
                DateTime this_end = packet_start;
                long totalDiff = Seconds.secondsBetween((ReadableInstant)packet_start, (ReadableInstant)packet_end).getSeconds();
                HashMap<String, Long> data_map = new HashMap<String, Long>();
                HashMap<String, Long> data_count = new HashMap<String, Long>();
                for (String dimension : this.splitter.getDimensions()) {
                    try {
                        if (!value.containsKey(dimension)) continue;
                        data_map.put(dimension, Long.parseLong(value.get(dimension).toString()));
                        data_count.put(dimension, 0L);
                    }
                    catch (NumberFormatException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                        return generatedPackets;
                    }
                }
                do {
                    DateTime this_start;
                    if ((this_end = (this_start = this_end).plusSeconds(this.splitter.getInterval() - this_start.getSecondOfMinute())).isAfter((ReadableInstant)packet_end)) {
                        this_end = packet_end;
                    }
                    long diff = Seconds.secondsBetween((ReadableInstant)this_start, (ReadableInstant)this_end).getSeconds();
                    HashMap<String, Object> to_send = new HashMap<String, Object>();
                    to_send.putAll(value);
                    to_send.put(this.splitter.getTimestampDim(), this_start.getMillis() / 1000L);
                    to_send.remove(this.splitter.getFirstTimestampDim());
                    for (Map.Entry entry : data_map.entrySet()) {
                        long this_data = totalDiff == 0L ? (Long)entry.getValue() : (long)Math.ceil((Long)entry.getValue() * diff / totalDiff);
                        Long data_dimension = (Long)data_count.get(entry.getKey());
                        data_dimension = data_dimension + this_data;
                        data_count.put((String)entry.getKey(), data_dimension);
                        to_send.put((String)entry.getKey(), this_data);
                    }
                    generatedPackets.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, to_send));
                } while (this_end.isBefore((ReadableInstant)packet_end));
                for (Map.Entry data : data_map.entrySet()) {
                    if (data.getValue() == data_count.get(data.getKey())) continue;
                    int last_index = generatedPackets.size() - 1;
                    KeyValue last = (KeyValue)generatedPackets.get(last_index);
                    long new_data = (Long)((Map)last.value).get(data.getKey()) + ((Long)data.getValue() - (Long)data_count.get(data.getKey()));
                    if (new_data <= 0L) continue;
                    ((Map)last.value).put(data.getKey(), new_data);
                }
            } else if (value.containsKey(this.splitter.getTimestampDim())) {
                try {
                    for (String dimension : this.splitter.getDimensions()) {
                        if (!value.containsKey(dimension)) continue;
                        Long data = Long.parseLong(value.get(dimension).toString());
                        value.put(dimension, data);
                    }
                    generatedPackets.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, value));
                }
                catch (NumberFormatException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    return generatedPackets;
                }
            } else {
                try {
                    for (String dimension : this.splitter.getDimensions()) {
                        if (!value.containsKey(dimension)) continue;
                        Long data = Long.parseLong(value.get(dimension).toString());
                        value.put(dimension, data);
                    }
                    generatedPackets.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, value));
                }
                catch (NumberFormatException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    return generatedPackets;
                }
            }
            return generatedPackets;
        }
        return null;
    }

    @Override
    public void stop() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.splitter.toString());
        builder.append("]");
        return builder.toString();
    }

    public class SplitterModel {
        List<String> dimensions;
        Integer interval;
        String firstTimestampDim = "last_timestamp";
        String timestampDim = "timestamp";

        SplitterModel(List<String> dimensions, String timestamp, String firstTimestamp, String interval) {
            this.dimensions = dimensions;
            if (firstTimestamp != null) {
                this.firstTimestampDim = firstTimestamp;
            }
            if (timestamp != null) {
                this.timestampDim = timestamp;
            }
            this.interval = interval != null ? Integer.valueOf(interval) : 60;
        }

        public List<String> getDimensions() {
            return this.dimensions;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public String getFirstTimestampDim() {
            return this.firstTimestampDim;
        }

        public String getTimestampDim() {
            return this.timestampDim;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" {").append("dimensions: ").append(this.dimensions).append(", ").append("timestampDim: ").append(this.timestampDim).append(", ").append("firstTimestampDim: ").append(this.firstTimestampDim).append(", ").append("interval: ").append(this.interval).append("} ");
            return builder.toString();
        }
    }
}

