/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KeyValue;

public class SimpleMapper
extends MapperFunction {
    List<MapperModel> mappers;
    boolean deleteMode;
    boolean deleteEmpty;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        List maps = (List)properties.get("maps");
        this.mappers = maps.stream().map(map -> new MapperModel((List)map.get("dimPath"), (String)map.get("as"))).collect(Collectors.toList());
        this.deleteMode = (Boolean)properties.getOrDefault("deleteMode", false);
        this.deleteEmpty = (Boolean)properties.getOrDefault("deleteEmpty", true);
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        HashMap<String, Object> newEvent = new HashMap<String, Object>();
        if (value != null && this.mappers != null) {
            if (this.deleteMode) {
                newEvent.putAll(value);
            }
            this.mappers.forEach(mapper -> {
                Object newValue;
                Integer n;
                Integer n2;
                Integer depth = mapper.dimPath.size() - 1;
                Map levelPath = this.deleteMode ? newEvent : new HashMap(value);
                LinkedList parents = new LinkedList();
                parents.add(newEvent);
                Integer level = 0;
                while (level < depth) {
                    block12: {
                        if (!this.deleteMode) {
                            if (levelPath != null && levelPath.get(mapper.dimPath.get(level)) instanceof Map) {
                                levelPath = (Map)levelPath.get(mapper.dimPath.get(level));
                                break block12;
                            } else {
                                levelPath = null;
                                break;
                            }
                        }
                        if (!(levelPath.get(mapper.dimPath.get(level)) instanceof Map)) break;
                        levelPath = (Map)levelPath.get(mapper.dimPath.get(level));
                        parents.add(levelPath);
                        if (level == depth - 1) {
                            levelPath.remove(mapper.dimPath.get(depth));
                        }
                    }
                    n2 = level;
                    n = level = Integer.valueOf(level + 1);
                }
                if (depth == 0) {
                    newEvent.remove(mapper.dimPath.get(depth));
                }
                if (this.deleteEmpty && this.deleteMode && parents.size() > 1) {
                    level = depth - 1;
                    while (level >= 0) {
                        if (((Map)((Map)parents.get(level)).get(mapper.dimPath.get(level))).isEmpty()) {
                            if (level == 0) {
                                newEvent.remove(mapper.dimPath.get(level));
                            } else {
                                ((Map)parents.get(level)).remove(mapper.dimPath.get(level));
                            }
                        }
                        n2 = level;
                        n = level = Integer.valueOf(level - 1);
                    }
                }
                if (levelPath != null && !this.deleteMode && (newValue = levelPath.get(mapper.dimPath.get(depth))) != null) {
                    newEvent.put(mapper.as, newValue);
                }
            });
            return new KeyValue((Object)key, newEvent);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        this.mappers.forEach(mapper -> builder.append(mapper.toString()));
        builder.append("]");
        return builder.toString();
    }

    public class MapperModel {
        List<String> dimPath;
        String as;

        MapperModel(List<String> dimPath, String as) {
            this.dimPath = dimPath;
            if (as != null) {
                this.as = as;
            } else if (dimPath != null) {
                this.as = dimPath.get(dimPath.size() - 1);
            }
        }

        public List<String> getDimPath() {
            return this.dimPath;
        }

        public String getAs() {
            return this.as;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" {").append("dimPath: ").append(this.dimPath).append(", ").append("as: ").append(this.as).append("} ");
            return builder.toString();
        }
    }
}

