/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KeyValue;

public class RenameMapper
extends MapperFunction {
    List<MapperModel> mappers;
    boolean deleteOldField;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        List maps = (List)properties.get("maps");
        this.deleteOldField = (Boolean)properties.getOrDefault("deleteOldField", true);
        this.mappers = maps.stream().map(map -> new MapperModel((List)map.get("dimPath"), (String)map.get("as"))).collect(Collectors.toList());
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null && this.mappers != null) {
            HashMap<String, Object> newEvent = new HashMap<String, Object>(value);
            this.mappers.forEach(mapper -> {
                Object newValue;
                Map levelPath;
                Integer depth = mapper.dimPath.size() - 1;
                Integer level = 0;
                for (levelPath = new HashMap(value); level < depth && levelPath != null; levelPath = (Map)levelPath.remove(mapper.dimPath.get(level))) {
                    Integer n = level;
                    Integer n2 = level = Integer.valueOf(level + 1);
                }
                if (levelPath != null && (newValue = levelPath.remove(mapper.dimPath.get(depth))) != null) {
                    newEvent.put(mapper.as, newValue);
                    if (this.deleteOldField) {
                        newEvent.remove(mapper.dimPath.get(0));
                    }
                }
            });
            return new KeyValue((Object)key, newEvent);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        this.mappers.forEach(mapper -> builder.append(mapper.toString()));
        builder.append("]");
        return builder.toString();
    }

    public class MapperModel {
        List<String> dimPath;
        String as;

        MapperModel(List<String> dimPath, String as) {
            this.dimPath = dimPath;
            if (as != null) {
                this.as = as;
            } else if (dimPath != null) {
                this.as = dimPath.get(dimPath.size() - 1);
            }
        }

        public List<String> getDimPath() {
            return this.dimPath;
        }

        public String getAs() {
            return this.as;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" {").append("dimPath: ").append(this.dimPath).append(", ").append("as: ").append(this.as).append("} ");
            return builder.toString();
        }
    }
}

