/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.streams.KeyValue;

public class RegexMapper
extends MapperFunction {
    public static final String GENERATE_DIMENSIONS = "generateDimensions";
    public static final String REGEX_PATTERN = "regexPattern";
    public static final String PARSE_DIMENSION = "parseDimension";
    private final String ERROR_MESSAGE_PATTERN = "%s cannot be null";
    List<String> generateDimensions;
    Pattern pattern;
    String parseDimension;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        String regexPattern = (String)Preconditions.checkNotNull((Object)properties.get(REGEX_PATTERN), (Object)String.format("%s cannot be null", REGEX_PATTERN));
        this.generateDimensions = (List)Preconditions.checkNotNull((Object)properties.get(GENERATE_DIMENSIONS), (Object)String.format("%s cannot be null", GENERATE_DIMENSIONS));
        this.parseDimension = (String)Preconditions.checkNotNull((Object)properties.get(PARSE_DIMENSION), (Object)String.format("%s cannot be null", PARSE_DIMENSION));
        this.pattern = Pattern.compile(regexPattern);
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        Object dimension;
        HashMap<String, Object> newValue = null;
        if (value != null && (dimension = (newValue = new HashMap<String, Object>(value)).get(this.parseDimension)) != null) {
            Matcher matcher = this.pattern.matcher(dimension.toString());
            while (matcher.find()) {
                for (String generateDimension : this.generateDimensions) {
                    newValue.put(generateDimension, matcher.group(generateDimension));
                }
            }
        }
        return new KeyValue((Object)key, newValue);
    }

    @Override
    public void stop() {
    }
}

