/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.FilterFunc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrFilter
extends FilterFunc {
    private static final Logger log = LoggerFactory.getLogger(OrFilter.class);
    List<FilterFunc> filters = new ArrayList<FilterFunc>();

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        List filtersMap = (List)properties.get("filters");
        for (Map filter : filtersMap) {
            String className = (String)filter.get("className");
            try {
                Class<?> funcClass = Class.forName(className);
                FilterFunc func = (FilterFunc)funcClass.newInstance();
                func.init((Map)filter.get("properties"), metricsManager);
                this.filters.add(func);
            }
            catch (ClassNotFoundException e) {
                log.error("Couldn't find the class associated with the function {}", (Object)className);
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("Couldn't create the instance associated with the function " + className, (Throwable)e);
            }
        }
    }

    @Override
    public Boolean process(String key, Map<String, Object> value) {
        if (value == null) {
            return false;
        }
        return this.filters.parallelStream().map(filter -> filter.test(key, value) == filter.match().booleanValue()).reduce((x, y) -> x != false || y != false).orElseGet(() -> Boolean.FALSE);
    }

    @Override
    public void stop() {
    }
}

