/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.FlatMapperFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JqFlatMapper
extends FlatMapperFunction {
    private static final Logger log = LoggerFactory.getLogger(JqFlatMapper.class);
    ObjectMapper MAPPER = new ObjectMapper();
    JsonQuery query;
    String jqQuery;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.jqQuery = (String)properties.get("jqQuery");
        if (this.jqQuery != null) {
            try {
                this.query = JsonQuery.compile((String)this.jqQuery);
            }
            catch (JsonQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Iterable<KeyValue<String, Map<String, Object>>> process(String key, Map<String, Object> value) {
        ArrayList<KeyValue<String, Map<String, Object>>> result = new ArrayList<KeyValue<String, Map<String, Object>>>();
        if (value != null) {
            JsonNode node = (JsonNode)this.MAPPER.convertValue(value, JsonNode.class);
            try {
                List resultQuery = this.query.apply(node);
                for (JsonNode r : resultQuery) {
                    Map map = (Map)this.MAPPER.convertValue((Object)r, Map.class);
                    result.add((KeyValue<String, Map<String, Object>>)new KeyValue((Object)key, (Object)map));
                }
            }
            catch (JsonQueryException e) {
                log.error("Error applying query " + this.jqQuery + " to message " + value, (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void stop() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" {").append("jqQuery: ").append(this.jqQuery).append("} ");
        return builder.toString();
    }
}

