/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KeyValue;

public class JoinMapper
extends MapperFunction {
    public static final String DIMENSION_NAME = "dimensionName";
    public static final String OR_DEFAULT = "orDefault";
    public static final String FROM_DIMENSION = "fromDimension";
    public static final String VALUES = "values";
    public static final String DELIMITIER = "delimitier";
    public static final String DELETE = "delete";
    private final String ERROR_MESSAGE_PATTERN = "%s cannot be null";
    String delimitier;
    List<Map<String, Object>> dimensionsToJoin;
    String newDimension;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.newDimension = (String)Preconditions.checkNotNull((Object)properties.get(DIMENSION_NAME), (Object)String.format("%s cannot be null", DIMENSION_NAME));
        this.dimensionsToJoin = properties.getOrDefault(VALUES, new ArrayList());
        this.dimensionsToJoin.forEach(map -> Preconditions.checkNotNull(map.get(FROM_DIMENSION), (Object)String.format("%s cannot be null", FROM_DIMENSION)));
        this.delimitier = (String)properties.getOrDefault(DELIMITIER, "-");
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        KeyValue returnedValue = new KeyValue((Object)key, new HashMap());
        if (value != null && this.newDimension != null) {
            String joined = this.dimensionsToJoin.stream().map(m -> {
                String objectValue = m.getOrDefault(DELETE, false) != false ? (String)value.remove(m.get(FROM_DIMENSION)) : (String)value.get(m.get(FROM_DIMENSION));
                return objectValue != null ? objectValue : (String)m.get(OR_DEFAULT);
            }).filter(Objects::nonNull).collect(Collectors.joining(this.delimitier));
            value.put(this.newDimension, joined);
            returnedValue = new KeyValue((Object)key, value);
        }
        return returnedValue;
    }

    @Override
    public void stop() {
    }
}

