/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.base.utils.ConvertFrom;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeConverterMapper
extends MapperFunction {
    List<Map<String, Object>> conversions;
    private static final Logger log = LoggerFactory.getLogger(FieldTypeConverterMapper.class);

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.conversions = (List)properties.get("conversions");
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> message) {
        if (message != null) {
            for (Map<String, Object> conversion : this.conversions) {
                String dimension = (String)Preconditions.checkNotNull((Object)((String)conversion.get("dimension")), (Object)"dimension cannot be null!");
                String newDimension = (String)conversion.get("newDimension");
                Object value = message.get(dimension);
                if (value == null) continue;
                String from = (String)Preconditions.checkNotNull((Object)((String)conversion.get("from")), (Object)"from cannot be null!");
                String to = (String)Preconditions.checkNotNull((Object)((String)conversion.get("to")), (Object)"to cannot be null!");
                Object convertedValue = null;
                switch (ConvertFrom.valueOf((String)to.toUpperCase())) {
                    case NUMBER: {
                        try {
                            convertedValue = ConvertFrom.valueOf((String)from.toUpperCase()).toNumber(value);
                        }
                        catch (ParseException e) {
                            log.debug("ParseException at ConvertFrom function.");
                        }
                        if (convertedValue != null) break;
                        log.debug("Value is null or cannot be converted");
                        break;
                    }
                    case STRING: {
                        convertedValue = ConvertFrom.valueOf((String)from.toUpperCase()).toString(value);
                        if (convertedValue != null) break;
                        log.debug("Value is null or cannot be converted");
                        break;
                    }
                    case BOOLEAN: {
                        convertedValue = ConvertFrom.valueOf((String)from.toUpperCase()).toBoolean(value);
                        if (convertedValue != null) break;
                        log.debug("Value is null or cannot be converted");
                    }
                }
                if (newDimension != null) {
                    message.put(newDimension, convertedValue);
                    continue;
                }
                message.put(dimension, convertedValue);
            }
            return new KeyValue((Object)key, message);
        }
        return new KeyValue((Object)key, null);
    }

    @Override
    public void stop() {
    }
}

