/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.normalizer.funcs.impl;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.metrics.MetricsManager;
import io.wizzie.normalizer.funcs.MapperFunction;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;

public class ClassificationMapper
extends MapperFunction {
    String dimension;
    String targetDimension;
    List<Number> intervals;
    List<String> classification;
    Number unknownValue;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.dimension = (String)Preconditions.checkNotNull((Object)((String)properties.get("dimension")), (Object)"dimension cannot be null");
        this.targetDimension = (String)Preconditions.checkNotNull((Object)((String)properties.get("new_dimension")), (Object)"new_dimension cannot be null");
        this.intervals = (List)Preconditions.checkNotNull((Object)((List)properties.get("intervals")), (Object)"intervals cannot be null");
        this.classification = (List)Preconditions.checkNotNull((Object)((List)properties.get("classification")), (Object)"classification cannot be null");
        this.unknownValue = (Number)Preconditions.checkNotNull((Object)((Number)properties.get("unknown_value")), (Object)"unknown_value cannot be null");
    }

    @Override
    public KeyValue<String, Map<String, Object>> process(String key, Map<String, Object> value) {
        if (value != null && value.containsKey(this.dimension)) {
            Number data = (Number)value.get(this.dimension);
            String classificationName = "not_classified";
            if (data.doubleValue() == this.unknownValue.doubleValue()) {
                classificationName = "unknown";
            } else {
                int i;
                for (i = 0; i < this.intervals.size(); ++i) {
                    if (!(data.doubleValue() <= this.intervals.get(i).doubleValue())) continue;
                    classificationName = this.classification.get(i);
                    break;
                }
                if (classificationName.equals("not_classified")) {
                    classificationName = this.classification.get(i);
                }
            }
            value.put(this.targetDimension, classificationName);
        }
        return new KeyValue((Object)key, value);
    }

    @Override
    public void stop() {
    }
}

